/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ExtractParameterAsLocalVariableFix;
import com.siyeh.ig.psiutils.WellFormednessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToForLoopParameterInspection
extends BaseInspection {
    public boolean m_checkForeachParameters = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.for.loop.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToForLoopParameterInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.for.loop.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToForLoopParameterInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assignment.to.for.loop.parameter.check.foreach.option", new Object[0]), (InspectionProfileEntry)this, "m_checkForeachParameters");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean foreachLoop = (Boolean)infos[0];
        if (!foreachLoop.booleanValue()) {
            return null;
        }
        return new ExtractParameterAsLocalVariableFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToForLoopParameterVisitor();
    }

    private class AssignmentToForLoopParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToForLoopParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/AssignmentToForLoopParameterInspection$AssignmentToForLoopParameterVisitor.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(expression);
            if (!WellFormednessUtils.isWellFormed(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            this.checkForForLoopParam(lhs);
            this.checkForForeachLoopParam(lhs);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/AssignmentToForLoopParameterInspection$AssignmentToForLoopParameterVisitor.visitPrefixExpression must not be null");
            }
            super.visitPrefixExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            this.checkForForLoopParam(operand);
            this.checkForForeachLoopParam(operand);
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/AssignmentToForLoopParameterInspection$AssignmentToForLoopParameterVisitor.visitPostfixExpression must not be null");
            }
            super.visitPostfixExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            this.checkForForLoopParam(operand);
            this.checkForForeachLoopParam(operand);
        }

        private void checkForForLoopParam(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            PsiElement element = ref.resolve();
            if (!(element instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)element;
            PsiDeclarationStatement decl = (PsiDeclarationStatement)variable.getParent();
            if (decl == null) {
                return;
            }
            if (!(decl.getParent() instanceof PsiForStatement)) {
                return;
            }
            PsiForStatement forStatement = (PsiForStatement)decl.getParent();
            assert (forStatement != null);
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return;
            }
            if (!initialization.equals(decl)) {
                return;
            }
            if (!this.isInForStatementBody(expression, forStatement)) {
                return;
            }
            this.registerError((PsiElement)expression, Boolean.FALSE);
        }

        private void checkForForeachLoopParam(PsiExpression expression) {
            if (!AssignmentToForLoopParameterInspection.this.m_checkForeachParameters) {
                return;
            }
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            PsiElement element = ref.resolve();
            if (!(element instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)element;
            if (!(parameter.getParent() instanceof PsiForeachStatement)) {
                return;
            }
            this.registerError((PsiElement)expression, Boolean.TRUE);
        }

        private boolean isInForStatementBody(PsiExpression expression, PsiForStatement statement) {
            PsiStatement body = statement.getBody();
            if (body == null) {
                return false;
            }
            return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)expression, (boolean)true);
        }
    }
}

