/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.util.io.FileUtil;
import org.jdom.Element;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenBeforeRunTask
extends BeforeRunTask {
    private String myProjectPath;
    private String myGoal;

    public MavenBeforeRunTask() {
    }

    public MavenBeforeRunTask(String projectPath, String goal) {
        this.myProjectPath = projectPath;
        this.myGoal = goal;
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public void setProjectPath(String projectPath) {
        this.myProjectPath = projectPath;
    }

    public String getGoal() {
        return this.myGoal;
    }

    public void setGoal(String goal) {
        this.myGoal = goal;
    }

    public boolean isFor(MavenProject project, String goal) {
        if (this.myProjectPath == null || this.myGoal == null) {
            return false;
        }
        return FileUtil.pathsEqual((String)project.getPath(), (String)this.myProjectPath) && goal.equals(this.myGoal);
    }

    public void writeExternal(Element element) {
        super.writeExternal(element);
        if (this.myProjectPath != null) {
            element.setAttribute("file", this.myProjectPath);
        }
        if (this.myGoal != null) {
            element.setAttribute("goal", this.myGoal);
        }
    }

    public void readExternal(Element element) {
        super.readExternal(element);
        this.myProjectPath = element.getAttributeValue("file");
        this.myGoal = element.getAttributeValue("goal");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenBeforeRunTask that = (MavenBeforeRunTask)((Object)o);
        if (this.myGoal != null ? !this.myGoal.equals(that.myGoal) : that.myGoal != null) {
            return false;
        }
        return !(this.myProjectPath != null ? !this.myProjectPath.equals(that.myProjectPath) : that.myProjectPath != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myProjectPath != null ? this.myProjectPath.hashCode() : 0);
        result = 31 * result + (this.myGoal != null ? this.myGoal.hashCode() : 0);
        return result;
    }
}

