/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Collection;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class ToggleProfileAction
extends MavenAction {
    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        if (!this.isAvailable(e)) {
            return;
        }
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(e);
        List profiles = (List)e.getData(MavenDataKeys.MAVEN_PROFILES);
        e.getPresentation().setText(this.isActive(projectsManager, profiles) ? ProjectBundle.message("maven.profile.deactivate", new Object[0]) : ProjectBundle.message("maven.profile.activate", new Object[0]));
    }

    @Override
    protected boolean isAvailable(AnActionEvent e) {
        if (!super.isAvailable(e)) {
            return false;
        }
        List selectedProfiles = (List)e.getData(MavenDataKeys.MAVEN_PROFILES);
        if (selectedProfiles == null || selectedProfiles.isEmpty()) {
            return false;
        }
        Collection<String> activeProfiles = MavenActionUtil.getProjectsManager(e).getExplicitProfiles();
        int activeCount = 0;
        for (String profile : selectedProfiles) {
            if (!activeProfiles.contains(profile)) continue;
            ++activeCount;
        }
        return activeCount == 0 || activeCount == selectedProfiles.size();
    }

    private boolean isActive(MavenProjectsManager projectsManager, List<String> profiles) {
        return projectsManager.getExplicitProfiles().contains(profiles.get(0));
    }

    public void actionPerformed(AnActionEvent e) {
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(e);
        List selectedProfiles = (List)e.getData(MavenDataKeys.MAVEN_PROFILES);
        Collection<String> activeProfiles = manager.getExplicitProfiles();
        if (this.isActive(manager, selectedProfiles)) {
            activeProfiles.removeAll(selectedProfiles);
        } else {
            activeProfiles.addAll(selectedProfiles);
        }
        manager.setExplicitProfiles(activeProfiles);
    }
}

