/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenArtifactDownloader {
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final MavenProjectsTree myProjectsTree;
    private final Collection<MavenProject> myMavenProjects;
    private final Collection<MavenArtifact> myArtifacts;
    private final MavenProgressIndicator myProgress;
    private final MavenEmbedderWrapper myEmbedder;

    public static DownloadResult download(MavenProjectsTree projectsTree, Collection<MavenProject> mavenProjects, @Nullable Collection<MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, MavenEmbedderWrapper embedder, MavenProgressIndicator p) throws MavenProcessCanceledException {
        return new MavenArtifactDownloader(projectsTree, mavenProjects, artifacts, embedder, p).download(downloadSources, downloadDocs);
    }

    private MavenArtifactDownloader(MavenProjectsTree projectsTree, Collection<MavenProject> mavenProjects, Collection<MavenArtifact> artifacts, MavenEmbedderWrapper embedder, MavenProgressIndicator p) {
        this.myProjectsTree = projectsTree;
        this.myMavenProjects = mavenProjects;
        this.myArtifacts = artifacts == null ? null : new THashSet(artifacts);
        this.myEmbedder = embedder;
        this.myProgress = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadResult download(boolean downloadSources, boolean downloadDocs) throws MavenProcessCanceledException {
        ArrayList<File> downloadedFiles = new ArrayList<File>();
        try {
            ArrayList<MavenExtraArtifactType> types = new ArrayList<MavenExtraArtifactType>(2);
            if (downloadSources) {
                types.add(MavenExtraArtifactType.SOURCES);
            }
            if (downloadDocs) {
                types.add(MavenExtraArtifactType.DOCS);
            }
            String caption = downloadSources && downloadDocs ? ProjectBundle.message("maven.downloading", new Object[0]) : (downloadSources ? ProjectBundle.message("maven.downloading.sources", new Object[0]) : ProjectBundle.message("maven.downloading.docs", new Object[0]));
            this.myProgress.setText(caption);
            Map<MavenId, DownloadData> artifacts = this.collectArtifactsToDownload(types);
            DownloadResult downloadResult = this.download(artifacts, downloadedFiles);
            return downloadResult;
        }
        finally {
            this.scheduleFilesRefresh(downloadedFiles);
        }
    }

    private void scheduleFilesRefresh(final List<File> downloadedFiles) {
        Runnable refreshTask = new Runnable(){

            @Override
            public void run() {
                LocalFileSystem.getInstance().refreshIoFiles((Iterable)downloadedFiles);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isDispatchThread()) {
            refreshTask.run();
        } else {
            ApplicationManager.getApplication().invokeLater(refreshTask);
        }
    }

    private Map<MavenId, DownloadData> collectArtifactsToDownload(List<MavenExtraArtifactType> types) {
        THashMap result = new THashMap();
        for (MavenProject eachProject : this.myMavenProjects) {
            List<MavenRemoteRepository> repositories = eachProject.getRemoteRepositories();
            for (MavenArtifact eachDependency : eachProject.getDependencies()) {
                if (this.myArtifacts != null && !this.myArtifacts.contains(eachDependency) || "system".equalsIgnoreCase(eachDependency.getScope()) || this.myProjectsTree.findProject(eachDependency.getMavenId()) != null || !eachProject.isSupportedDependency(eachDependency)) continue;
                MavenId id = eachDependency.getMavenId();
                DownloadData data = (DownloadData)result.get(id);
                if (data == null) {
                    data = new DownloadData();
                    result.put(id, data);
                }
                data.repositories.addAll(repositories);
                for (MavenExtraArtifactType eachType : types) {
                    data.classifiersWithExtensions.add(new DownloadElement(eachProject.getClassifierAndExtension(eachDependency, eachType), eachType));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadResult download(Map<MavenId, DownloadData> toDownload, final List<File> downloadedFiles) throws MavenProcessCanceledException {
        ArrayList futures = new ArrayList();
        final AtomicInteger downloaded = new AtomicInteger();
        int total = 0;
        for (DownloadData each : toDownload.values()) {
            total += each.classifiersWithExtensions.size();
        }
        final DownloadResult result = new DownloadResult();
        result.unresolvedSources.addAll(toDownload.keySet());
        result.unresolvedDocs.addAll(toDownload.keySet());
        try {
            for (Map.Entry<MavenId, DownloadData> entry : toDownload.entrySet()) {
                this.myProgress.checkCanceled();
                final DownloadData data = entry.getValue();
                final MavenId id = entry.getKey();
                for (final DownloadElement eachElement : data.classifiersWithExtensions) {
                    final int finalTotal = total;
                    futures.add(EXECUTOR.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block9: {
                                try {
                                    MavenArtifactDownloader.this.myProgress.checkCanceled();
                                    MavenArtifactDownloader.this.myProgress.setFraction((double)downloaded.getAndIncrement() / (double)finalTotal);
                                    Artifact a = MavenArtifactDownloader.this.myEmbedder.resolve(id, eachElement.extension, eachElement.classifier, new ArrayList<MavenRemoteRepository>(data.repositories));
                                    File file = a.getFile();
                                    if (file == null || !file.exists()) break block9;
                                    List list = downloadedFiles;
                                    synchronized (list) {
                                        downloadedFiles.add(file);
                                        switch (eachElement.type) {
                                            case SOURCES: {
                                                result.resolvedSources.add(id);
                                                result.unresolvedSources.remove(id);
                                                break;
                                            }
                                            case DOCS: {
                                                result.resolvedDocs.add(id);
                                                result.unresolvedDocs.remove(id);
                                            }
                                        }
                                    }
                                }
                                catch (MavenProcessCanceledException mavenProcessCanceledException) {
                                    // empty catch block
                                }
                            }
                        }
                    }));
                }
            }
        }
        finally {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        }
        return result;
    }

    public static class DownloadResult {
        public final Set<MavenId> resolvedSources = new THashSet();
        public final Set<MavenId> resolvedDocs = new THashSet();
        public final Set<MavenId> unresolvedSources = new THashSet();
        public final Set<MavenId> unresolvedDocs = new THashSet();
    }

    private static class DownloadElement {
        public final String classifier;
        public final String extension;
        public final MavenExtraArtifactType type;

        public DownloadElement(Pair<String, String> classifierAndExtension, MavenExtraArtifactType type) {
            this.classifier = (String)classifierAndExtension.first;
            this.extension = (String)classifierAndExtension.second;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DownloadElement that = (DownloadElement)o;
            if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
                return false;
            }
            if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.classifier != null ? this.classifier.hashCode() : 0;
            result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    private static class DownloadData {
        public final LinkedHashSet<MavenRemoteRepository> repositories = new LinkedHashSet();
        public final LinkedHashSet<DownloadElement> classifiersWithExtensions = new LinkedHashSet();

        private DownloadData() {
        }
    }
}

