/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.references.MavenTargetUtil;

public class MavenPropertyRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(DataContext context) {
        return this.findTarget(context) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/refactorings/MavenPropertyRenameHandler.invoke must not be null");
        }
        this.invoke(project, PsiElement.EMPTY_ARRAY, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/refactorings/MavenPropertyRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/refactorings/MavenPropertyRenameHandler.invoke must not be null");
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = this.findTarget(dataContext);
        }
        RenameDialog dialog = new RenameDialog(project, element, null, (Editor)PlatformDataKeys.EDITOR.getData(dataContext));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String name = (String)DEFAULT_NAME.getData(dataContext);
            dialog.performRename(name);
        } else {
            dialog.show();
        }
    }

    private PsiElement findTarget(DataContext context) {
        return MavenTargetUtil.getRefactorTarget((Editor)PlatformDataKeys.EDITOR.getData(context), (PsiFile)LangDataKeys.PSI_FILE.getData(context));
    }
}

