#!/bin/sh
echo 'name: tls
version: 0.8.1
id: tls-0.8.1-f1f8e9be66748f0f58b1ec6c43c05e52

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
package-url:
synopsis: TLS/SSL protocol native implementation (Server and Client)
description: Native Haskell TLS and SSL protocol implementation for server and client.
             .
             This provides a high-level implementation of a sensitive security protocol,
             eliminating a common set of security issues through the use of the advanced
             type system, high level constructions and common Haskell features.
             .
             Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
             with only RSA supported for Key Exchange.
             .
             Only core protocol available here, have a look at the
             <http://hackage.haskell.org/package/tls-extra/> package for default
             ciphers, compressions and certificates functions.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-tls
exposed: True
exposed-modules: Network.TLS Network.TLS.Cipher
                 Network.TLS.Compression Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.MAC
                Network.TLS.Core Network.TLS.Crypto Network.TLS.Packet
                Network.TLS.Record Network.TLS.State Network.TLS.Sending
                Network.TLS.Receiving Network.TLS.Util Network.TLS.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/tls-0.8.1
library-dirs: /usr/local/lib/ghc/tls-0.8.1
hs-libraries: HStls-0.8.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         cereal-0.3.5.2-4a36143bb9e4836e68fcbca872fdfe0f
         certificate-0.9.5-0e1622acd8f419063779ab99693f89e9
         crypto-api-0.10.2-7b007cd3db78fd29c91c1498400296d7
         cryptocipher-0.2.8-52cf293221edd2a95e8b37fd63b58d3f
         cryptohash-0.7.0-43d46cb497d58495d1058869142c097c
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tls-0.8.1/html/tls.haddock
haddock-html: /usr/local/share/doc/hs-tls-0.8.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
