#!/bin/sh
echo 'name: test-framework
version: 0.6
id: test-framework-0.6-1ff3fb29a54c3a442d5c4580d4adb6ec

license: BSD3
copyright:
maintainer: Max Bolingbroke <batterseapower@hotmail.com>
stability:
homepage: http://batterseapower.github.com/test-framework/
package-url:
synopsis: Framework for running and organising tests, with HUnit and QuickCheck support
description: Allows tests such as QuickCheck properties and HUnit test cases to be assembled into test groups, run in
             parallel (but reported in deterministic order, to aid diff interpretation) and filtered and controlled by
             command line options. All of this comes with colored test output, progress reporting and test statistics output.
category: Testing
author: Max Bolingbroke <batterseapower@hotmail.com>
pkgpath: devel/hs-test-framework
exposed: True
exposed-modules: Test.Framework Test.Framework.Options
                 Test.Framework.Providers.API Test.Framework.Runners.Console
                 Test.Framework.Runners.Options Test.Framework.Seed
hidden-modules: Test.Framework.Core Test.Framework.Improving
                Test.Framework.Runners.Console.Colors
                Test.Framework.Runners.Console.ProgressBar
                Test.Framework.Runners.Console.Run
                Test.Framework.Runners.Console.Statistics
                Test.Framework.Runners.Console.Table
                Test.Framework.Runners.Console.Utilities
                Test.Framework.Runners.Core Test.Framework.Runners.Processors
                Test.Framework.Runners.Statistics
                Test.Framework.Runners.TestPattern
                Test.Framework.Runners.ThreadPool
                Test.Framework.Runners.TimedConsumption
                Test.Framework.Runners.XML.JUnitWriter Test.Framework.Runners.XML
                Test.Framework.Utilities
trusted: False
import-dirs: /usr/local/lib/ghc/test-framework-0.6
library-dirs: /usr/local/lib/ghc/test-framework-0.6
hs-libraries: HStest-framework-0.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ansi-terminal-0.5.5-8801f5127d93c5faa91ff9c937224633
         ansi-wl-pprint-0.6.4-58a91878f1dc9e4da8ec86dc39bc034b
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         extensible-exceptions-0.1.1.4-3d9bd197c43329612c640f24179a7f19
         hostname-1.0-1275a0ca77236572babdc116ce2069ce
         old-locale-1.0.0.4-b1d945ebea59a524cba400a524cb40aa
         random-1.0.1.1-597e5fbb16214a2d52b559b0643d1749
         regex-posix-0.95.2-d9fe86a76ffc5af4d3ed783956717b13
         time-1.4-b8e1c3d423daa1e2c5470a82caf23b52
         xml-1.3.7-784c5faa3c47c87d00afd76eb644e04b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-test-framework-0.6/html/test-framework.haddock
haddock-html: /usr/local/share/doc/hs-test-framework-0.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
