#!/bin/sh
echo 'name: tar
version: 0.4.0.1
id: tar-0.4.0.1-5b2cd0f2de16ec46ac4573c6296b85ab

license: BSD3
copyright: 2007 Bjorn Bringert <bjorn@bringert.net>
           2008-2012 Duncan Coutts <duncan@community.haskell.org>
maintainer: Duncan Coutts <duncan@community.haskell.org>
stability:
homepage:
package-url:
synopsis: Reading, writing and manipulating ".tar" archive files.
description: This library is for working with \"@.tar@\" archive files. It
             can read and write a range of common variations of archive
             format including V7, USTAR, POSIX and GNU formats. It provides
             support for packing and unpacking portable archives. This
             makes it suitable for distribution but not backup because
             details like file ownership and exact permissions are not
             preserved.
category: Codec
author: Bjorn Bringert <bjorn@bringert.net>
        Duncan Coutts <duncan@community.haskell.org>
pkgpath: devel/hs-tar
exposed: True
exposed-modules: Codec.Archive.Tar Codec.Archive.Tar.Entry
                 Codec.Archive.Tar.Check
hidden-modules: Codec.Archive.Tar.Types Codec.Archive.Tar.Read
                Codec.Archive.Tar.Write Codec.Archive.Tar.Pack
                Codec.Archive.Tar.Unpack
trusted: False
import-dirs: /usr/local/lib/ghc/tar-0.4.0.1
library-dirs: /usr/local/lib/ghc/tar-0.4.0.1
hs-libraries: HStar-0.4.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         directory-1.1.0.2-4b2070a8941d5c76e41241a2ac457927
         filepath-1.3.0.0-954c43b4f109cbd4121f1231c14d5cff
         old-time-1.1.0.0-3e0f7b48d6c1d1415ad852e23725fdc1
         time-1.4-b8e1c3d423daa1e2c5470a82caf23b52
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tar-0.4.0.1/html/tar.haddock
haddock-html: /usr/local/share/doc/hs-tar-0.4.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
