#!/bin/sh
echo 'name: tagsoup
version: 0.12.8
id: tagsoup-0.12.8-4b0fe41c5770b3c8970753c143dc0392

license: BSD3
copyright: Neil Mitchell 2006-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/tagsoup/
package-url:
synopsis: Parsing and extracting information from (possibly malformed) HTML/XML documents
description: TagSoup is a library for parsing HTML/XML. It supports the HTML 5 specification,
             and can be used to parse either well-formed XML, or unstructured and malformed HTML
             from the web. The library also provides useful functions to extract information
             from an HTML document, making it ideal for screen-scraping.
             .
             Users should start from the "Text.HTML.TagSoup" module.
category: XML
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: textproc/hs-tagsoup
exposed: True
exposed-modules: Text.HTML.Download Text.HTML.TagSoup
                 Text.HTML.TagSoup.Entity Text.HTML.TagSoup.Match
                 Text.HTML.TagSoup.Tree Text.StringLike
hidden-modules: Text.HTML.TagSoup.Generated
                Text.HTML.TagSoup.Implementation Text.HTML.TagSoup.Manual
                Text.HTML.TagSoup.Options Text.HTML.TagSoup.Parser
                Text.HTML.TagSoup.Render Text.HTML.TagSoup.Specification
                Text.HTML.TagSoup.Type
trusted: False
import-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
library-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
hs-libraries: HStagsoup-0.12.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         network-2.3.1.0-e56ec3d5abd17b7b386690bf49d424ab
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tagsoup-0.12.8/html/tagsoup.haddock
haddock-html: /usr/local/share/doc/hs-tagsoup-0.12.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
