#!/bin/sh
echo 'name: syntactic
version: 1.4
id: syntactic-1.4-5d0ac047fcc0191c81887a88cebbd33d

license: BSD3
copyright: Copyright (c) 2011-2012, Emil Axelsson
maintainer: emax@chalmers.se
stability:
homepage: http://projects.haskell.org/syntactic/
package-url:
synopsis: Generic abstract syntax, and utilities for embedded languages
description: This library provides:
             .
             * Generic representation and manipulation of abstract syntax
             .
             * Composable AST representations (partly based on Data Types à
             la Carte [1])
             .
             * A collection of common syntactic constructs, including
             variable binding constructs
             .
             * Utilities for analyzing and transforming generic abstract
             syntax
             .
             * Utilities for building extensible embedded languages based
             on generic syntax
             .
             For more information about the core functionality, see
             \"A Generic Abstract Syntax Model for Embedded Languages\"
             (ICFP 2012):
             .
             * Paper:
             <http://www.cse.chalmers.se/~emax/documents/axelsson2012generic.pdf>
             .
             * Slides:
             <http://www.cse.chalmers.se/~emax/documents/axelsson2012generic-slides.pdf>
             .
             For a practical example of how to use the library, see the
             proof-of-concept implementation Feldspar EDSL in the @examples@
             directory. (The real Feldspar [2] is also implemented using
             Syntactic.)
             .
             The maturity of this library varies between different modules.
             The core part ("Language.Syntactic") is rather stable, but many
             of the other modules are in a much more experimental state.
             .
             \[1\] W. Swierstra. Data Types à la Carte.
             /Journal of Functional Programming/, 18(4):423-436, 2008,
             <http://dx.doi.org/10.1017/S0956796808006758>.
             .
             \[2\] <http://hackage.haskell.org/package/feldspar-language>
category: Language
author: Emil Axelsson
pkgpath: lang/hs-syntactic
exposed: True
exposed-modules: Data.PolyProxy Data.DynamicAlt Language.Syntactic
                 Language.Syntactic.Syntax Language.Syntactic.Traversal
                 Language.Syntactic.Constraint Language.Syntactic.Sugar
                 Language.Syntactic.Interpretation.Equality
                 Language.Syntactic.Interpretation.Evaluation
                 Language.Syntactic.Interpretation.Render
                 Language.Syntactic.Interpretation.Semantics
                 Language.Syntactic.Constructs.Binding
                 Language.Syntactic.Constructs.Binding.HigherOrder
                 Language.Syntactic.Constructs.Binding.Optimize
                 Language.Syntactic.Constructs.Condition
                 Language.Syntactic.Constructs.Construct
                 Language.Syntactic.Constructs.Decoration
                 Language.Syntactic.Constructs.Identity
                 Language.Syntactic.Constructs.Literal
                 Language.Syntactic.Constructs.Monad
                 Language.Syntactic.Constructs.Tuple
                 Language.Syntactic.Frontend.Monad Language.Syntactic.Frontend.Tuple
                 Language.Syntactic.Frontend.TupleConstrained
                 Language.Syntactic.Sharing.SimpleCodeMotion
                 Language.Syntactic.Sharing.Utils Language.Syntactic.Sharing.Graph
                 Language.Syntactic.Sharing.StableName
                 Language.Syntactic.Sharing.Reify Language.Syntactic.Sharing.ReifyHO
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/syntactic-1.4
library-dirs: /usr/local/lib/ghc/syntactic-1.4
hs-libraries: HSsyntactic-1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-4f6c2a594155b0b953c1cf0f54040f61
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         constraints-0.3.2-ef4c87b9c74a4fb2236418d885452d0d
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         data-hash-0.1.0.0-352bb8bc936f31e81fe7d265a35e3ab2
         ghc-prim-0.2.0.0-23f345e1ec26a64d5ebc768bd0b2a5d9
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         transformers-0.3.0.0-2889ebed7e61112cda7ded5e4c153bcf
         tuple-0.2.0.1-5849de90ca5f385508091ea1a44778a5
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-syntactic-1.4/html/syntactic.haddock
haddock-html: /usr/local/share/doc/hs-syntactic-1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
