#!/bin/sh
echo 'name: snap-core
version: 0.9.2.2
id: snap-core-0.9.2.2-74df8aee5648a9fe2906d831371ab2bc

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: Snap: A Haskell Web Framework (core interfaces and types)
description: Snap is a simple and fast web development framework and server written in
             Haskell. For more information or to download the latest version, you can
             visit the Snap project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core",
             some iteratee utilities are in "Snap.Iteratee".
category: Web, Snap
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Snap.Core Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Exceptions
                 Snap.Internal.Http.Types Snap.Internal.Iteratee.Debug
                 Snap.Internal.Parsing Snap.Test Snap.Types.Headers
                 Snap.Util.FileServe Snap.Util.FileUploads Snap.Util.GZip
                 Snap.Util.Proxy Snap.Util.Readable
hidden-modules: Snap.Internal.Instances
                Snap.Internal.Iteratee.BoyerMooreHorspool
                Snap.Internal.Parsing.FastSet Snap.Internal.Routing
                Snap.Internal.Types Snap.Internal.Test.RequestBuilder
                Snap.Internal.Test.Assertions
trusted: False
import-dirs: /usr/local/lib/ghc/snap-core-0.9.2.2
library-dirs: /usr/local/lib/ghc/snap-core-0.9.2.2
hs-libraries: HSsnap-core-0.9.2.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.1-04fafbcfa793ac20134c5b9972485d17
         MonadCatchIO-transformers-0.3.0.0-3d9f2598a492284fcb08e73b1981b4a4
         attoparsec-0.10.1.0-3149dba69bd6a508e5a21c7e9cf969a8
         attoparsec-enumerator-0.3-e16616615c93a4bab12cbaad5f63f76f
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         blaze-builder-0.2.1.4-cbacb369ecb80a55dd55bab68eb21ee1
         blaze-builder-enumerator-0.2.0.4-084ae88fa2f45a7cf6c98461d286584d
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         bytestring-mmap-0.2.2-f43aedba6773dbccad28c4d79ae18979
         case-insensitive-0.4.0.1-6ab4ff76a505da904c51cb94c3242e3c
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         deepseq-1.3.0.0-c8a9e8b538aecb7581533b9c1d19faed
         directory-1.1.0.2-4b2070a8941d5c76e41241a2ac457927
         enumerator-0.4.19-54652fc37c21c9ff6bc4aced898d00e5
         filepath-1.3.0.0-954c43b4f109cbd4121f1231c14d5cff
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         random-1.0.1.1-597e5fbb16214a2d52b559b0643d1749
         regex-posix-0.95.2-d9fe86a76ffc5af4d3ed783956717b13
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
         time-1.4-b8e1c3d423daa1e2c5470a82caf23b52
         unix-2.5.1.1-c23dadb7ccff9eeb5d1df0bd91909ca9
         unix-compat-0.3.0.1-7c43122b26d2af8f349878266d10ac1d
         unordered-containers-0.1.4.6-3501841bb7a7f313c99e53e7965a1a02
         vector-0.10.0.1-fdf8e0c3f3c1cae1113ab97c34aa5c14
         zlib-enum-0.2.2.1-f794f2612eaee96fd0337998dab8896a
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.9.2.2/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.9.2.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
