#!/bin/sh
echo 'name: skein
version: 0.1.0.9
id: skein-0.1.0.9-905e4bb0b2c3d6591f12197a33cf61d1

license: BSD3
copyright:
maintainer: Felipe Lessa <felipe.lessa@gmail.com>
stability:
homepage: https://github.com/meteficha/skein
package-url:
synopsis: Skein, a family of cryptographic hash functions.  Includes Skein-MAC as well.
description: Skein (<http://www.skein-hash.info/>) is a family of fast
             secure cryptographic hash functions designed by Niels
             Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir
             Bellare, Tadayoshi Kohno, Jon Callas and Jesse Walker.
             .
             This package uses bindings to the optimized C implementation
             of Skein.  We provide a high-level interface (see module
             "Crypto.Skein") to some of the Skein use cases.  We also
             provide a low-level interface (see module
             "Crypto.Skein.Internal") should you need to use Skein in a
             different way.
             .
             Currently we have support for Skein as cryptographic hash
             function as Skein as a message authentication code
             (Skein-MAC).  For examples of how to use this package, see
             "Crypto.Skein" module documentation.
category: Cryptography
author: Felipe Lessa <felipe.lessa@gmail.com>, Doug Whiting
pkgpath: security/hs-skein
exposed: True
exposed-modules: Crypto.Skein Crypto.Skein.Internal
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/skein-0.1.0.9
library-dirs: /usr/local/lib/ghc/skein-0.1.0.9
hs-libraries: HSskein-0.1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes: skein.h
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         cereal-0.3.5.2-4a36143bb9e4836e68fcbca872fdfe0f
         crypto-api-0.10.2-7b007cd3db78fd29c91c1498400296d7
         tagged-0.4.4-55c603ce43bd5a4d0399cb94469b9536
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-skein-0.1.0.9/html/skein.haddock
haddock-html: /usr/local/share/doc/hs-skein-0.1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
