#!/bin/sh
echo 'name: semigroupoids
version: 1.3.4
id: semigroupoids-1.3.4-8ce2b0ba3157019940e024b2c2e6db6e

license: BSD3
copyright: Copyright (C) 2011 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
package-url:
synopsis: Haskell 98 semigroupoids: Category sans id
description: Provides a wide array of semigroupoids and operations for working with semigroupds.
             .
             A Semigroupoid is a Category without the requirement of identity arrows for every object in the category.
             .
             When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
             not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
             in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
             .
             Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
             .
             .
             Ideally the following relationships would hold:
             .
             > Traversable <---- Foldable <--- Functor ------> Alt ---------> Plus           Semigroupoid
             >      |               |            |                              |                  |
             >      v               v            v                              v                  v
             > Traversable1 <--- Foldable1     Apply --------> Applicative -> Alternative      Category
             >                                   |               |              |                  |
             >                                   v               v              v                  v
             >                                 Bind ---------> Monad -------> MonadPlus          Arrow
             >
             .
             Apply, Bind, and Extract give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
             .
             This lets us remove many of the restrictions from various monad transformers
             as in many cases the binding operation or @\<*\>@ operation does not require them.
             .
             Finally, to work with these weaker structures it is beneficial to have containers
             that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
             and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
pkgpath: devel/hs-semigroupoids
exposed: True
exposed-modules: Data.Functor.Alt Data.Functor.Apply
                 Data.Functor.Bind Data.Functor.Bind.Trans Data.Functor.Plus
                 Data.Semigroup.Foldable Data.Semigroup.Traversable
                 Data.Semigroupoid Data.Semigroupoid.Dual Data.Semigroupoid.Static
                 Data.Traversable.Instances
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/semigroupoids-1.3.4
library-dirs: /usr/local/lib/ghc/semigroupoids-1.3.4
hs-libraries: HSsemigroupoids-1.3.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         comonad-1.1.1.6-dd5dd7695d817faf53b6216185136d16
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         contravariant-0.2.0.2-81baf5bc59727b7a0ef0352dbc950025
         semigroups-0.8.3.2-b6db8c87ad6d53e4c1738e03a3006530
         transformers-0.3.0.0-2889ebed7e61112cda7ded5e4c153bcf
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-semigroupoids-1.3.4/html/semigroupoids.haddock
haddock-html: /usr/local/share/doc/hs-semigroupoids-1.3.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
