#!/bin/sh
echo 'name: mwc-random
version: 0.12.0.1
id: mwc-random-0.12.0.1-9a26e9ff0db17dfb9559e9037e7d7b67

license: BSD3
copyright: 2009, 2010, 2011 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability:
homepage: https://github.com/bos/mwc-random
package-url:
synopsis: Fast, high quality pseudo random number generation
description: This package contains code for generating high quality random
             numbers that follow either a uniform or normal distribution.  The
             generated numbers are suitable for use in statistical applications.
             .
             The uniform PRNG uses Marsaglia'\''s MWC256 (also known as MWC8222)
             multiply-with-carry generator, which has a period of 2^8222 and
             fares well in tests of randomness.  It is also extremely fast,
             between 2 and 3 times faster than the Mersenne Twister.
             .
             Compared to the mersenne-random package, this package has a more
             convenient API, is faster, and supports more statistical
             distributions.
category: Math, Statistics
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: security/hs-mwc-random
exposed: True
exposed-modules: System.Random.MWC System.Random.MWC.Distributions
                 System.Random.MWC.CondensedTable
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/mwc-random-0.12.0.1
library-dirs: /usr/local/lib/ghc/mwc-random-0.12.0.1
hs-libraries: HSmwc-random-0.12.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         primitive-0.5.0.1-a269ac922313cfdb63da08f8624fba7d
         time-1.4-b8e1c3d423daa1e2c5470a82caf23b52
         vector-0.10.0.1-fdf8e0c3f3c1cae1113ab97c34aa5c14
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-mwc-random-0.12.0.1/html/mwc-random.haddock
haddock-html: /usr/local/share/doc/hs-mwc-random-0.12.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
