#!/bin/sh
echo 'name: monad-par
version: 0.3
id: monad-par-0.3-4bc8e0ab06cc90b84ed961006bf51e08

license: BSD3
copyright: (c) Simon Marlow 2011
maintainer: Simon Marlow <marlowsd@gmail.com>
stability: Experimental
homepage: https://github.com/simonmar/monad-par
package-url:
synopsis: A library for parallel programming based on a monad
description: This library offers an alternative parallel programming
             API to that provided by the @parallel@ package.
             A '\''Par'\'' monad allows the simple description of
             parallel computations, and can be used to add
             parallelism to pure Haskell code.  The basic API
             is straightforward: the monad supports forking
             and simple communication in terms of '\''IVar'\''s.
             The library comes with a work-stealing
             implementation, but the internals are also
             exposed so that you can build your own scheduler
             if necessary.
             Examples of use can be found in the examples/ directory
             of the source package.
             The modules below provide additionaly schedulers,
             data structures, and other added capabilities
             layered on top of the '\''Par'\'' monad.
category: Control,Parallelism,Monads
author: Simon Marlow
pkgpath: devel/hs-monad-par
exposed: True
exposed-modules: Control.Monad.Par Control.Monad.Par.Scheds.Trace
                 Control.Monad.Par.Scheds.TraceInternal
                 Control.Monad.Par.Scheds.Direct Control.Monad.Par.Scheds.Sparks
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/monad-par-0.3
library-dirs: /usr/local/lib/ghc/monad-par-0.3
hs-libraries: HSmonad-par-0.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: abstract-deque-0.1.6-44fc5e0b7d2be94adc890f7952490190
         abstract-par-0.3.1-1434948e47afdbd6fee3113f1738784f
         array-0.4.0.0-4f6c2a594155b0b953c1cf0f54040f61
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         deepseq-1.3.0.0-c8a9e8b538aecb7581533b9c1d19faed
         monad-par-extras-0.3.2-57d5c890ddc69a6f8496318bf4205074
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         mwc-random-0.12.0.1-9a26e9ff0db17dfb9559e9037e7d7b67
         parallel-3.2.0.3-0c734151f27a50a329a35e705f0ba330
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-monad-par-0.3/html/monad-par.haddock
haddock-html: /usr/local/share/doc/hs-monad-par-0.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
