#!/bin/sh
echo 'name: hexpat
version: 0.19.10
id: hexpat-0.19.10-cebdd726e6baf215e49cb2684b249ebf

license: BSD3
copyright: (c) 2009 Doug Beardsley <mightybyte@gmail.com>,
           (c) 2009-2012 Stephen Blackheath <http://blacksapphire.com/antispam/>,
           (c) 2009 Gregory Collins,
           (c) 2008 Evan Martin <martine@danga.com>,
           (c) 2009 Matthew Pocock <matthew.pocock@ncl.ac.uk>,
           (c) 2007-2009 Galois Inc.,
           (c) 2010 Kevin Jardine,
           (c) 2012 Simon Hengel
maintainer: http://blacksapphire.com/antispam/
stability: beta
homepage: http://haskell.org/haskellwiki/Hexpat/
package-url:
synopsis: XML parser/formatter based on expat
description: This package provides a general purpose Haskell XML library using Expat to
             do its parsing (<http://expat.sourceforge.net/> - a fast stream-oriented XML
             parser written in C).  It is extensible to any string type, with @String@,
             @ByteString@ and @Text@ provided out of the box.
             .
             Basic usage: Parsing a tree (/Tree/), formatting a tree (/Format/).
             Other features: Helpers for processing XML trees (/Proc/), trees annotated with
             XML source location (/Annotated/), extended XML trees with comments,
             processing instructions, etc (/Extended/), XML cursors (/Cursor/),
             SAX-style parse (/SAX/), and access to the low-level interface in case speed
             is paramount (/Internal.IO/).
             .
             The design goals are speed, speed, speed, interface simplicity and modularity.
             .
             For introduction and examples, see the /Text.XML.Expat.Tree/ module. For benchmarks,
             <http://haskell.org/haskellwiki/Hexpat/>
             .
             If you want to do interactive I\/O, an obvious option is to use lazy parsing
             with one of the lazy I\/O functions such as hGetContents.  However, this can be
             problematic in some applications because it doesn'\''t handle I\/O errors properly
             and can give no guarantee of timely resource cleanup.  In these cases, chunked
             I\/O is a better approach: Take a look at the /hexpat-enumerator/ package.
             .
             /IO/ is filed under /Internal/ because it'\''s low-level and most users won'\''t want
             it.  The other /Internal/ modules are re-exported by /Annotated/, /Tree/ and /Extended/,
             so you won'\''t need to import them directly.
             .
             Credits to Iavor Diatchki and the @xml@ (XML.Light) package for /Proc/ and /Cursor/.
             Thanks to the many contributors.
             .
             BOUND VS. UNBOUND THREADS: GHC (at least versions 6.12.X) will spawn threads
             if you call a safe FFI callback from an unbound thread.  This can get out of
             control in a busy application.  To avoid this, from version 0.19.1 we now delegate
             processing to a single worker thread if the calling thread is not bound.
             This essentially means that hexpat currently won'\''t exploit multicores very well.
             It also means that hexpat may be more efficient on threads spawned with forkOS
             (to give you a bound thread) rather than forkIO.
             .
             ChangeLog: 0.15 changes intended to fix a (rare) \"error: a C finalizer called back into Haskell.\"
             that seemed only to happen only on ghc6.12.X; 0.15.1 Fix broken Annotated parse;
             0.16 switch from mtl to transformers; 0.17 fix mapNodeContainer & rename some things.;
             0.18 rename defaultEncoding to overrideEncoding. 0.18.3 formatG and indent were demanding list
             items more than once (inefficient in chunked processing); 0.19 add Extended.hs;
             0.19.1 fix a memory leak introduced in 0.19, delegate parsing to bound thread
             if unbound (see note above); 0.19.2 include expat source code so \'\''cabal install\'\'' just works
             on Linux, Mac and Windows (thanks Jacob Stanley); 0.19.3 fix misconfiguration of expat
             which broke entity parsing; 0.19.4 bump version constraint for text; 0.19.5 bump text
             to < 0.12 and fix text-0.10.0.1 breakage; 0.19.6 dependency breakage with List;
             0.19.7 ghc-7.2.1 compatibility; 0.19.8 fix space leak on lazy parse under ghc-7.2.1;
             0.19.9 fix formatting of > character + improve performance; 0.9.10 ghc-7.4.x compatibility.
category: XML
author: Stephen Blackheath [blackh] (the primary author),
        Doug Beardsley,
        Gregory Collins,
        Evan Martin (who started the project),
        Matthew Pocock [drdozer],
        Kevin Jardine,
        Jacob Stanley,
        Simon Hengel
pkgpath: textproc/hs-hexpat
exposed: True
exposed-modules: Text.XML.Expat.Annotated Text.XML.Expat.Cursor
                 Text.XML.Expat.Extended Text.XML.Expat.Format Text.XML.Expat.IO
                 Text.XML.Expat.Namespaced Text.XML.Expat.NodeClass
                 Text.XML.Expat.Proc Text.XML.Expat.Qualified Text.XML.Expat.SAX
                 Text.XML.Expat.Tree Text.XML.Expat.Internal.DocumentClass
                 Text.XML.Expat.Internal.IO Text.XML.Expat.Internal.Namespaced
                 Text.XML.Expat.Internal.NodeClass Text.XML.Expat.Internal.Qualified
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/hexpat-0.19.10
library-dirs: /usr/local/lib/ghc/hexpat-0.19.10
hs-libraries: HShexpat-0.19.10
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: List-0.4.2-ba978299e527f5eda39e0538fef5b2ed
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         deepseq-1.3.0.0-c8a9e8b538aecb7581533b9c1d19faed
         extensible-exceptions-0.1.1.4-3d9bd197c43329612c640f24179a7f19
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
         transformers-0.3.0.0-2889ebed7e61112cda7ded5e4c153bcf
         utf8-string-0.3.8-d5e5121211c1ffe304a6efae5f108415
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hexpat-0.19.10/html/hexpat.haddock
haddock-html: /usr/local/share/doc/hs-hexpat-0.19.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
