#!/bin/sh
echo 'name: hashed-storage
version: 0.5.9
id: hashed-storage-0.5.9-778379ff3ed51c2c99a0605c6587e32a

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
synopsis: Hashed file storage support code.
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.9
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.9
hs-libraries: HShashed-storage-0.5.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         binary-0.5.1.0-3fa096318e49568943a31c01a2cfa4c8
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         dataenc-0.14.0.3-965da51e4be8b07cbfa4bc2907558edb
         directory-1.1.0.2-4b2070a8941d5c76e41241a2ac457927
         extensible-exceptions-0.1.1.4-3d9bd197c43329612c640f24179a7f19
         filepath-1.3.0.0-954c43b4f109cbd4121f1231c14d5cff
         mmap-0.5.6-2d20ab97542d0dece3a059ea85aa867a
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         zlib-0.5.4.0-0d818ac207ea095f2439042e85ca4d8f
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.9/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
