#!/bin/sh
echo 'name: dbus
version: 0.10.4
id: dbus-0.10.4-995ca4e8a713019b81fa32153016123f

license: GPL-3
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
package-url:
synopsis: A client library for the D-Bus IPC system.
description: D-Bus is a simple, message-based protocol for inter-process
             communication, which allows applications to interact with other parts of
             the machine and the user'\''s session using remote procedure calls.
             .
             D-Bus is a essential part of the modern Linux desktop, where it replaces
             earlier protocols such as CORBA and DCOP.
             .
             This library is an implementation of the D-Bus protocol in Haskell. It
             can be used to add D-Bus support to Haskell applications, without the
             awkward interfaces common to foreign bindings.
             .
             Example: connect to the session bus, and get a list of active names.
             .
             @
             &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
             .
             import Data.List (sort)
             import DBus
             import DBus.Client
             .
             main = do
             &#x20;   client <- connectSession
             &#x20;   //
             &#x20;   \-- Request a list of connected clients from the bus
             &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
             &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
             &#x20;       &#x7d;
             &#x20;   //
             &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
             &#x20;   \-- a list of names (here represented as [String])
             &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
             &#x20;   //
             &#x20;   \-- Print each name on a line, sorted so reserved names are below
             &#x20;   \-- temporary names.
             &#x20;   mapM_ putStrLn (sort names)
             @
             .
             >$ ghc --make list-names.hs
             >$ ./list-names
             >:1.0
             >:1.1
             >:1.10
             >:1.106
             >:1.109
             >:1.110
             >ca.desrt.dconf
             >org.freedesktop.DBus
             >org.freedesktop.Notifications
             >org.freedesktop.secrets
             >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <jmillikin@gmail.com>
pkgpath: x11/hs-dbus
exposed: True
exposed-modules: DBus DBus.Client DBus.Introspection DBus.Socket
                 DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.4
library-dirs: /usr/local/lib/ghc/dbus-0.10.4
hs-libraries: HSdbus-0.10.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         cereal-0.3.5.2-4a36143bb9e4836e68fcbca872fdfe0f
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         libxml-sax-0.7.3-4d7bf44748f452ac926840e9dc8fd387
         network-2.3.1.0-e56ec3d5abd17b7b386690bf49d424ab
         parsec-3.1.3-fb970d7908f363dfef34b141200235e6
         random-1.0.1.1-597e5fbb16214a2d52b559b0643d1749
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
         transformers-0.3.0.0-2889ebed7e61112cda7ded5e4c153bcf
         unix-2.5.1.1-c23dadb7ccff9eeb5d1df0bd91909ca9
         vector-0.10.0.1-fdf8e0c3f3c1cae1113ab97c34aa5c14
         xml-types-0.3.3-8e79f499fd27fa0e4937a91944392f17
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.4/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
