#!/bin/sh
echo 'name: Crypto
version: 4.2.5
id: Crypto-4.2.5-0e71dd8012acad4cfe9c3467c4050c9e

license: OtherLicense
copyright: Dominic Steinitz 2003 - 2007
maintainer: Caylee Hogg <caylee.hogg@gmail.com>
stability: Alpha
homepage:
package-url:
synopsis: Collects together existing Haskell cryptographic functions into a package
description: DES, Blowfish, AES, TEA, SHA1, MD5, RSA, BubbleBabble,
             Hexdump, Support for Word128, Word192 and Word256 and Beyond, PKCS5
             Padding, Various Encryption Modes e.g. Cipher Block Chaining all in one package,
             with HUnit and QuickCheck tests, and examples.
category: Cryptography, Codec
author: Dominic Steinitz
pkgpath: security/hs-crypto
exposed: True
exposed-modules: Codec.Binary.BubbleBabble Codec.Encryption.RSA
                 Codec.Encryption.RSA.EMEOAEP Codec.Encryption.RSA.MGF
                 Codec.Encryption.RSA.NumberTheory Codec.Encryption.DES
                 Codec.Encryption.AES Codec.Encryption.TEA Codec.Encryption.Blowfish
                 Codec.Encryption.Modes Codec.Encryption.Padding Codec.Text.Raw
                 Codec.Utils Data.Digest.MD5 Data.Digest.SHA1 Data.Digest.SHA2
                 Data.Digest.SHA224 Data.Digest.SHA256 Data.Digest.SHA384
                 Data.Digest.SHA512 Data.LargeWord Data.HMAC
hidden-modules: Codec.Encryption.BlowfishAux
                Codec.Encryption.DESAux Codec.Encryption.AESAux Data.Digest.MD5Aux
trusted: False
import-dirs: /usr/local/lib/ghc/Crypto-4.2.5
library-dirs: /usr/local/lib/ghc/Crypto-4.2.5
hs-libraries: HSCrypto-4.2.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.1-04fafbcfa793ac20134c5b9972485d17
         QuickCheck-2.5.1.1-4b3daf6f1579962bcef10ad37634c8ea
         array-0.4.0.0-4f6c2a594155b0b953c1cf0f54040f61
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         pretty-1.1.1.0-867dcdeb02592f3d2a707618561c7b86
         random-1.0.1.1-597e5fbb16214a2d52b559b0643d1749
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-Crypto-4.2.5/html/Crypto.haddock
haddock-html: /usr/local/share/doc/hs-Crypto-4.2.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
