#!/bin/sh
echo 'name: cprng-aes
version: 0.2.3
id: cprng-aes-0.2.3-e0e3c1fbe74713eae6b93162b530f0aa

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-cprng-aes
package-url:
synopsis: Crypto Pseudo Random Number Generator using AES in counter mode.
description: Simple crypto pseudo-random-number-generator with really good randomness property.
             .
             Using ent, a randomness property maker on one 1Mb sample:
             Entropy = 7.999837 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 237.02
             Arithmetic mean value of data bytes is 127.3422 (127.5 = random)
             Monte Carlo value for Pi is 3.143589568 (error 0.06 percent)
             .
             Compared to urandom with the same sampling:
             Entropy = 7.999831 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 246.63
             Arithmetic mean value of data bytes is 127.6347 (127.5 = random).
             Monte Carlo value for Pi is 3.132465868 (error 0.29 percent).
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cprng-aes
exposed: True
exposed-modules: Crypto.Random.AESCtr
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
library-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
hs-libraries: HScprng-aes-0.2.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         cereal-0.3.5.2-4a36143bb9e4836e68fcbca872fdfe0f
         crypto-api-0.10.2-7b007cd3db78fd29c91c1498400296d7
         cryptocipher-0.2.8-52cf293221edd2a95e8b37fd63b58d3f
         entropy-0.2.1-e5d282f7531f6aa000696f5415aba45a
         random-1.0.1.1-597e5fbb16214a2d52b559b0643d1749
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cprng-aes-0.2.3/html/cprng-aes.haddock
haddock-html: /usr/local/share/doc/hs-cprng-aes-0.2.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
