#!/bin/sh
echo 'name: convertible
version: 1.0.11.1
id: convertible-1.0.11.1-5173ffddd165cd30127b020492efa41e

license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
synopsis: Typeclasses and instances for converting between types
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
library-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
hs-libraries: HSconvertible-1.0.11.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         old-locale-1.0.0.4-b1d945ebea59a524cba400a524cb40aa
         old-time-1.1.0.0-3e0f7b48d6c1d1415ad852e23725fdc1
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
         time-1.4-b8e1c3d423daa1e2c5470a82caf23b52
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.11.1/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.11.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
