#!/bin/sh
echo 'name: configurator
version: 0.2.0.0
id: configurator-0.2.0.0-3e94550844c72f2e0e84f73536376857

license: BSD3
copyright: Copyright 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: http://github.com/bos/configurator
package-url:
synopsis: Configuration management
description: A configuration management library for programs and daemons.
             .
             Features include:
             .
             * Automatic, dynamic reloading in response to modifications to
             configuration files.
             .
             * A simple, but flexible, configuration language, supporting several
             of the most commonly needed types of data, along with
             interpolation of strings from the configuration or the system
             environment (e.g. @$(HOME)@).
             .
             * Subscription-based notification of changes to configuration
             properties.
             .
             * An @import@ directive allows the configuration of a complex
             application to be split across several smaller files, or common
             configuration data to be shared across several applications.
             .
             For details of the configuration file format, see
             <http://hackage.haskell.org/packages/archive/configurator/latest/doc/html/Data-Configurator.html>.
category: Configuration, Data
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-configurator
exposed: True
exposed-modules: Data.Configurator Data.Configurator.Types
hidden-modules: Data.Configurator.Instances
                Data.Configurator.Parser Data.Configurator.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
library-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
hs-libraries: HSconfigurator-0.2.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.1.0-3149dba69bd6a508e5a21c7e9cf969a8
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         directory-1.1.0.2-4b2070a8941d5c76e41241a2ac457927
         hashable-1.1.2.3-1e9e274afb8e07dab57c2a975698461b
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
         unix-compat-0.3.0.1-7c43122b26d2af8f349878266d10ac1d
         unordered-containers-0.1.4.6-3501841bb7a7f313c99e53e7965a1a02
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-configurator-0.2.0.0/html/configurator.haddock
haddock-html: /usr/local/share/doc/hs-configurator-0.2.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
