#!/bin/sh
echo 'name: conduit
version: 0.4.2
id: conduit-0.4.2-e8d5c4153d76f3672eace08aa0cd55be

license: BSD3
copyright:
maintainer: michael@snoyman.com
stability:
homepage: http://github.com/snoyberg/conduit
package-url:
synopsis: Streaming data processing library.
description: Conduits are an approach to the streaming data problem. It is meant as an alternative to enumerators\/iterators, hoping to address the same issues with different trade-offs based on real-world experience with enumerators. For more information, see <http://www.yesodweb.com/book/conduits>.
             .
             Release history:
             .
             [0.4] Inspired by the design of the pipes package: we now have a single unified type underlying @Source@, @Sink@, and @Conduit@. This type is named @Pipe@. There are type synonyms provided for the other three types. Additionally, @BufferedSource@ is no longer provided. Instead, the connect-and-resume operator, @$$+@, can be used for the same purpose.
             .
             [0.3] ResourceT has been greatly simplified, specialized for IO, and moved into a separate package. Instead of hard-coding ResourceT into the conduit datatypes, they can now live around any monad. The Conduit datatype has been enhanced to better allow generation of streaming output. The SourceResult, SinkResult, and ConduitResult datatypes have been removed entirely.
             .
             [0.2] Instead of storing state in mutable variables, we now use CPS. A @Source@ returns the next @Source@, and likewise for @Sink@s and @Conduit@s. Not only does this take better advantage of GHC\'\''s optimizations (about a 20% speedup), but it allows some operations to have a reduction in algorithmic complexity from exponential to linear. This also allowed us to remove the @Prepared@ set of types. Also, the @State@ functions (e.g., @sinkState@) use better constructors for return types, avoiding the need for a dummy state on completion.
             .
             [0.1] @BufferedSource@ is now an abstract type, and has a much more efficient internal representation. The result was a 41% speedup on microbenchmarks (note: do not expect speedups anywhere near that in real usage). In general, we are moving towards @BufferedSource@ being a specific tool used internally as needed, but using @Source@ for all external APIs.
             .
             [0.0] Initial release.
category: Data, Conduit
author: Michael Snoyman
pkgpath: devel/hs-conduit
exposed: True
exposed-modules: Data.Conduit Data.Conduit.Binary Data.Conduit.Text
                 Data.Conduit.List Data.Conduit.Lazy Data.Conduit.Internal
hidden-modules: System.PosixFile Data.Conduit.Util.Source
                Data.Conduit.Util.Sink Data.Conduit.Util.Conduit
trusted: False
import-dirs: /usr/local/lib/ghc/conduit-0.4.2
library-dirs: /usr/local/lib/ghc/conduit-0.4.2
hs-libraries: HSconduit-0.4.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         lifted-base-0.1.1.1-d132bf72b99009be080f6908f5e294ec
         monad-control-0.3.1.4-1d52a0e52c2ed35102613ba7d521f3af
         resourcet-0.3.3.1-aeb47046710b94587845e5b9d129941e
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
         transformers-0.3.0.0-2889ebed7e61112cda7ded5e4c153bcf
         transformers-base-0.4.1-9023dccd35c525f9deca7e00af9540a5
         void-0.5.6-d63987a49cebf67bff39a79b17a16fb0
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-conduit-0.4.2/html/conduit.haddock
haddock-html: /usr/local/share/doc/hs-conduit-0.4.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
