#!/bin/sh
echo 'name: blaze-builder
version: 0.2.1.4
id: blaze-builder-0.2.1.4-cbacb369ecb80a55dd55bab68eb21ee1

license: BSD3
copyright: 2010 Simon Meier
           2010 Jasper Van der Jeugt
maintainer: Simon Meier <iridcode@gmail.com>
stability: Experimental
homepage: http://github.com/meiersi/blaze-builder
package-url:
synopsis: Efficient buffered output.
description: This library provides an abstraction of buffered output of
             byte streams and several convenience functions to exploit
             it. For example, it allows to efficiently serialize
             Haskell values to lazy bytestrings with a large average
             chunk size. The large average chunk size allows to make
             good use of cache prefetching in later processing steps
             (e.g. compression) and reduces the sytem call overhead
             when writing the resulting lazy bytestring to a file or
             sending it over the network.
category: Data
author: Jasper Van der Jeugt, Simon Meier
pkgpath: devel/hs-blaze-builder
exposed: True
exposed-modules: Blaze.ByteString.Builder
                 Blaze.ByteString.Builder.Int Blaze.ByteString.Builder.Word
                 Blaze.ByteString.Builder.ByteString
                 Blaze.ByteString.Builder.Char.Utf8 Blaze.ByteString.Builder.Char8
                 Blaze.ByteString.Builder.Html.Utf8 Blaze.ByteString.Builder.HTTP
                 Blaze.ByteString.Builder.Internal
                 Blaze.ByteString.Builder.Internal.Write
                 Blaze.ByteString.Builder.Internal.Types
                 Blaze.ByteString.Builder.Internal.Buffer
hidden-modules: Blaze.ByteString.Builder.Internal.UncheckedShifts
trusted: False
import-dirs: /usr/local/lib/ghc/blaze-builder-0.2.1.4
library-dirs: /usr/local/lib/ghc/blaze-builder-0.2.1.4
hs-libraries: HSblaze-builder-0.2.1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-blaze-builder-0.2.1.4/html/blaze-builder.haddock
haddock-html: /usr/local/share/doc/hs-blaze-builder-0.2.1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
