#!/bin/sh
echo 'name: attoparsec-enumerator
version: 0.3
id: attoparsec-enumerator-0.3-e16616615c93a4bab12cbaad5f63f76f

license: MIT
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/attoparsec-enumerator/
package-url:
synopsis: Pass input from an enumerator to an Attoparsec parser.
description: This library allows an Attoparsec parser to receive input incrementally
             from an enumerator. This could be used for parsing large files, or
             implementing binary network protocols.
             .
             > (-# LANGUAGE OverloadedStrings #-)
             >
             > import Control.Applicative
             > import Data.Attoparsec
             > import Data.Attoparsec.Enumerator
             > import Data.Enumerator
             > import Data.Enumerator.Binary (enumHandle)
             > import Data.Enumerator.List
             > import System.IO
             >
             > parser = string "foo" <|> string "bar"
             >
             > main = do
             >     xy <- run_ (enumHandle 1 stdin $$ do
             >         x <- iterParser parser
             >         y <- iterParser parser
             >         return (x, y))
             >     print xy
category: Text, Parsing, Enumerator
author: John Millikin <jmillikin@gmail.com>
pkgpath: textproc/hs-attoparsec-enumerator
exposed: True
exposed-modules: Data.Attoparsec.Enumerator
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3
library-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3
hs-libraries: HSattoparsec-enumerator-0.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.1.0-3149dba69bd6a508e5a21c7e9cf969a8
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         enumerator-0.4.19-54652fc37c21c9ff6bc4aced898d00e5
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-attoparsec-enumerator-0.3/html/attoparsec-enumerator.haddock
haddock-html: /usr/local/share/doc/hs-attoparsec-enumerator-0.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
