#!/bin/sh
echo 'name: atom
version: 1.0.9
id: atom-1.0.9-8dd98bb891ff61cc72aea5da2e680c24

license: BSD3
copyright:
maintainer: Tom Hawkins <tomahawkins@gmail.com>, Lee Pike <leepike@gmail.com>
stability:
homepage: http://tomahawkins.org
package-url:
synopsis: A DSL for embedded hard realtime applications.
description: Atom is a Haskell DSL for designing hard realtime embedded software.
             Based on guarded atomic actions (similar to STM), Atom enables
             highly concurrent programming without the need for mutex locking.
             In addition, Atom performs compile-time task scheduling and generates code
             with deterministic execution time and constant memory use, simplifying the
             process of timing verification and memory consumption in hard realtime applications.
             Without mutex locking and run-time task scheduling, Atom eliminates
             the need and overhead of RTOSs for many embedded applications.
category: Language, Embedded
author: Tom Hawkins <tomahawkins@gmail.com>
pkgpath: devel/hs-atom
exposed: True
exposed-modules: Language.Atom Language.Atom.Analysis
                 Language.Atom.Code Language.Atom.Common Language.Atom.Compile
                 Language.Atom.Elaboration Language.Atom.Example
                 Language.Atom.Expressions Language.Atom.Language
                 Language.Atom.Scheduling Language.Atom.Unit Language.Atom.UeMap
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/atom-1.0.9
library-dirs: /usr/local/lib/ghc/atom-1.0.9
hs-libraries: HSatom-1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bimap-0.2.4-b972d9cdc559163fb3c5b3692d88e9b1
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         process-1.1.0.1-c55e7a2b0eb5149f070b14e14bea1c83
         syb-0.3.7-a269c050536d4890f37a20513844e800
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-atom-1.0.9/html/atom.haddock
haddock-html: /usr/local/share/doc/hs-atom-1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
