#!/bin/sh
echo 'name: aeson
version: 0.6.0.2
id: aeson-0.6.0.2-157531de53c6d98f8fb3771b2b5cb201

license: BSD3
copyright: (c) 2011 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: https://github.com/bos/aeson
package-url:
synopsis: Fast JSON parsing and encoding
description: A JSON parsing and encoding library optimized for ease of use
             and high performance.
             .
             To get started, see the documentation for the @Data.Aeson@ module
             below.
             .
             For release notes, see
             <https://github.com/bos/aeson/blob/master/release-notes.markdown>
             .
             /Note/: if you use GHCi or Template Haskell, please see the
             @README@ file for important details about building this package,
             and other packages that depend on it:
             <https://github.com/bos/aeson#readme>
             .
             Parsing performance on a late 2010 MacBook Pro (2.66GHz Core i7),
             for mostly-English tweets from Twitter'\''s JSON search API:
             .
             * 0.8 KB, 32-bit GHC 6.12.3: 30538 msg\/sec (24.9 MB\/sec)
             .
             * 0.8 KB, 64-bit GHC 7.0.3: 31204 msg\/sec (25.4 MB\/sec)
             .
             * 6.4 KB, 32-bit GHC 6.12.3: 6731 msg\/sec (42.3 MB\/sec)
             .
             * 6.4 KB, 64-bit GHC 7.0.3: 6627 msg\/sec (41.7 MB\/sec)
             .
             * 11.8 KB, 32-bit GHC 6.12.3: 3751 msg\/sec (43.2 MB\/sec)
             .
             * 11.8 KB, 64-bit GHC 7.0.3: 3381 msg\/sec (38.9 MB\/sec)
             .
             * 31.2 KB, 32-bit GHC 6.12.3: 1306 msg\/sec (39.8 MB\/sec)
             .
             * 31.2 KB, 64-bit GHC 7.0.3: 1132 msg\/sec (34.5 MB\/sec)
             .
             * 61.5 KB, 32-bit GHC 6.12.3: 616 msg\/sec (37.0 MB\/sec)
             .
             * 61.5 KB, 64-bit GHC 7.0.3: 534 msg\/sec (32.1 MB\/sec)
             .
             Handling heavily-escaped text is a little more work.  Here is
             parsing performance with Japanese tweets, where much of the text
             is entirely Unicode-escaped.
             .
             * 14.6 KB, 32-bit GHC 6.12.3: 2315 msg\/sec (33.1 MB\/sec)
             .
             * 14.6 KB, 64-bit GHC 7.0.3: 1986 msg\/sec (28.4 MB\/sec)
             .
             * 44.1 KB, 32-bit GHC 6.12.3: 712 msg\/sec (30.7 MB\/sec)
             .
             * 44.1 KB, 64-bit GHC 7.0.3: 634 msg\/sec (27.3 MB\/sec)
             .
             * 82.9 KB, 32-bit GHC 6.12.3: 377 msg\/sec (30.5 MB\/sec)
             .
             * 82.9 KB, 64-bit GHC 7.0.3: 332 msg\/sec (26.9 MB\/sec)
             .
             Encoding performance on the same machine and data:
             .
             * English, 854 bytes: 43439 msg\/sec (35.4 MB/sec)
             .
             * English, 6.4 KB: 7127 msg\/sec (44.8 MB/sec)
             .
             * Engish, 61.5 KB: 765 msg\/sec (46.0 MB/sec)
             .
             * Japanese, 14.6 KB: 4727 msg\/sec (67.5 MB/sec)
             .
             * Japanese, 44.1 KB: 1505 msg\/sec (64.8 MB/sec)
             .
             (A note on naming: in Greek mythology, Aeson was the father of Jason.)
category: Text, Web, JSON
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-aeson
exposed: True
exposed-modules: Data.Aeson Data.Aeson.Encode Data.Aeson.Generic
                 Data.Aeson.Parser Data.Aeson.Types Data.Aeson.TH
hidden-modules: Data.Aeson.Types.Generic Data.Aeson.Functions
                Data.Aeson.Parser.Internal Data.Aeson.Types.Class
                Data.Aeson.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
library-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
hs-libraries: HSaeson-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.1.0-3149dba69bd6a508e5a21c7e9cf969a8
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         blaze-builder-0.2.1.4-cbacb369ecb80a55dd55bab68eb21ee1
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         deepseq-1.3.0.0-c8a9e8b538aecb7581533b9c1d19faed
         dlist-0.5-645574c332014f535d55f2387855cdd7
         ghc-prim-0.2.0.0-23f345e1ec26a64d5ebc768bd0b2a5d9
         hashable-1.1.2.3-1e9e274afb8e07dab57c2a975698461b
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         old-locale-1.0.0.4-b1d945ebea59a524cba400a524cb40aa
         syb-0.3.7-a269c050536d4890f37a20513844e800
         template-haskell-2.7.0.0-a8fc6af10e016d4c8fff69196193b62c
         text-0.11.2.3-6d44323283fc0f3935743a72b4424942
         time-1.4-b8e1c3d423daa1e2c5470a82caf23b52
         unordered-containers-0.1.4.6-3501841bb7a7f313c99e53e7965a1a02
         vector-0.10.0.1-fdf8e0c3f3c1cae1113ab97c34aa5c14
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-aeson-0.6.0.2/html/aeson.haddock
haddock-html: /usr/local/share/doc/hs-aeson-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
