#!/bin/sh
echo 'name: HTTP
version: 4000.2.5
id: HTTP-4000.2.5-cd8b9cedb7cf101615e89651acbe49e7

license: BSD3
copyright:
maintainer: Ganesh Sittampalam <http@projects.haskell.org>
stability:
homepage: https://github.com/haskell/HTTP
package-url:
synopsis: A library for client-side HTTP
description: The HTTP package supports client-side web programming in Haskell. It lets you set up
             HTTP connections, transmitting requests and processing the responses coming back, all
             from within the comforts of Haskell. It'\''s dependent on the network package to operate,
             but other than that, the implementation is all written in Haskell.
             .
             A basic API for issuing single HTTP requests + receiving responses is provided. On top
             of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
             it taking care of handling the management of persistent connections, proxies,
             state (cookies) and authentication credentials required to handle multi-step
             interactions with a web server.
             .
             The representation of the bytes flowing across is extensible via the use of a type class,
             letting you pick the representation of requests and responses that best fits your use.
             Some pre-packaged, common instances are provided for you (@ByteString@, @String@.)
             .
             Here'\''s an example use:
             .
             >
             >    do
             >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
             >              -- fetch document and return it (as a '\''String'\''.)
             >      fmap (take 100) (getResponseBody rsp)
             >
             >    do
             >      (_, rsp)
             >         <- Network.Browser.browse $ do
             >               setAllowRedirects True -- handle HTTP redirects
             >               request $ getRequest "http://www.haskell.org/"
             >      return (take 100 (rspBody rsp))
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
pkgpath: net/hs-HTTP
exposed: True
exposed-modules: Network.BufferType Network.Stream
                 Network.StreamDebugger Network.StreamSocket Network.TCP
                 Network.HTTP Network.HTTP.Headers Network.HTTP.Base
                 Network.HTTP.Stream Network.HTTP.Auth Network.HTTP.Cookie
                 Network.HTTP.Proxy Network.HTTP.HandleStream Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
trusted: False
import-dirs: /usr/local/lib/ghc/HTTP-4000.2.5
library-dirs: /usr/local/lib/ghc/HTTP-4000.2.5
hs-libraries: HSHTTP-4000.2.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-4f6c2a594155b0b953c1cf0f54040f61
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         bytestring-0.9.2.1-3c5b69d9d36e3a0179d120b97025ab86
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         network-2.3.1.0-e56ec3d5abd17b7b386690bf49d424ab
         old-time-1.1.0.0-3e0f7b48d6c1d1415ad852e23725fdc1
         parsec-3.1.3-fb970d7908f363dfef34b141200235e6
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.2.5/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.2.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
