#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2002-2006  Donald N. Allingham
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# $Id: _HasRepo.py 14091 2010-01-18 04:42:17Z pez4brian $

#-------------------------------------------------------------------------
#
# Standard Python modules
#
#-------------------------------------------------------------------------
from gen.ggettext import gettext as _

#-------------------------------------------------------------------------
#
# GRAMPS modules
#
#-------------------------------------------------------------------------
from gen.lib import RepositoryType
from Filters.Rules._Rule import Rule

#-------------------------------------------------------------------------
#
# HasEvent
#
#-------------------------------------------------------------------------
class HasRepo(Rule):
    """Rule that checks for a repo with a particular value"""


    labels      = [ _('Name:'), 
                    _('Type:'), 
                    _('Address:'),
                    _('URL:'), 
                    ]
    name        = _('Repositories matching parameters')
    description = _("Matches Repositories with particular parameters")
    category    = _('General filters')

    def apply(self,db,repo):
        if not self.match_substring(0,repo.get_name()):
            return False

        if self.list[1]:
            specified_type = RepositoryType()
            specified_type.set_from_xml_str(self.list[1])
            if repo.type != specified_type:
                return False

        if self.list[2]:
            addr_match = False
            for addr in repo.address_list:
                addr_text = addr.city + addr.state + addr.country \
                            + addr.postal + addr.phone + addr.street

                if self.match_substring(2,addr_text):
                    addr_match = True
                    break
            if not addr_match:
                return False

        if self.list[3]:
            url_match = False
            for url in repo.urls:
                url_text = url.path + url.desc
                if self.match_substring(3,url_text):
                    url_match = True
                    break
            if not url_match:
                return False

        return True
