/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class BlockView
extends BoxView {
    private AttributeSet attributes;
    StyleSheet.BoxPainter painter;
    private Length[] cssSpans = new Length[2];
    private HashMap positionInfo = new HashMap();

    public BlockView(Element elem, int axis) {
        super(elem, axis);
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        if (r == null) {
            r = new SizeRequirements();
        }
        if (this.setCSSSpan(r, axis)) {
            SizeRequirements parent = super.calculateMajorAxisRequirements(axis, null);
            int margin = axis == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            r.minimum -= margin;
            r.preferred -= margin;
            r.maximum -= margin;
            this.constrainSize(axis, r, parent);
        } else {
            r = super.calculateMajorAxisRequirements(axis, r);
        }
        return r;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        Object o;
        if (r == null) {
            r = new SizeRequirements();
        }
        if (this.setCSSSpan(r, axis)) {
            SizeRequirements parent = super.calculateMinorAxisRequirements(axis, null);
            int margin = axis == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            r.minimum -= margin;
            r.preferred -= margin;
            r.maximum -= margin;
            this.constrainSize(axis, r, parent);
        } else {
            r = super.calculateMinorAxisRequirements(axis, r);
        }
        if (axis == 0 && (o = this.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            String al = o.toString().trim();
            r.alignment = al.equals("center") ? 0.5f : (al.equals("right") ? 1.0f : 0.0f);
        }
        return r;
    }

    private boolean setCSSSpan(SizeRequirements r, int axis) {
        boolean ret = false;
        Length span = this.cssSpans[axis];
        if (span != null && !span.isPercentage()) {
            r.minimum = (int)span.getValue();
            r.preferred = (int)span.getValue();
            r.maximum = (int)span.getValue();
            ret = true;
        }
        return ret;
    }

    private void constrainSize(int axis, SizeRequirements r, SizeRequirements min) {
        if (min.minimum > r.minimum) {
            r.minimum = min.minimum;
            r.preferred = min.minimum;
            r.maximum = Math.max(r.maximum, min.maximum);
        }
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int viewCount = this.getViewCount();
        int i = 0;
        while (i < viewCount) {
            View view = this.getView(i);
            int min = (int)view.getMinimumSpan(axis);
            Length length = this.cssSpans[axis];
            int max = length != null ? (min = Math.max((int)length.getValue(targetSpan), min)) : (int)view.getMaximumSpan(axis);
            if (max < targetSpan) {
                float align = view.getAlignment(axis);
                offsets[i] = (int)((float)(targetSpan - max) * align);
                spans[i] = max;
            } else {
                offsets[i] = 0;
                spans[i] = Math.max(min, targetSpan);
            }
            this.positionView(targetSpan, axis, i, offsets, spans);
            ++i;
        }
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        super.layoutMajorAxis(targetSpan, axis, offsets, spans);
        int viewCount = this.getViewCount();
        int i = 0;
        while (i < viewCount) {
            this.positionView(targetSpan, axis, i, offsets, spans);
            ++i;
        }
    }

    private void positionView(int targetSpan, int axis, int i, int[] offsets, int[] spans) {
        View view = this.getView(i);
        PositionInfo pos = (PositionInfo)this.positionInfo.get(view);
        if (pos != null) {
            int p0 = -1;
            int p1 = -1;
            if (axis == 0) {
                Length l = pos.left;
                if (l != null) {
                    p0 = (int)l.getValue(targetSpan);
                }
                if ((l = pos.right) != null) {
                    p1 = (int)l.getValue(targetSpan);
                }
            } else {
                Length l = pos.top;
                if (l != null) {
                    p0 = (int)l.getValue(targetSpan);
                }
                if ((l = pos.bottom) != null) {
                    p1 = (int)l.getValue(targetSpan);
                }
            }
            if (pos.type == 2 || pos.type == 3) {
                if (p0 != -1) {
                    offsets[i] = p0;
                    if (p1 != -1) {
                        spans[i] = targetSpan - p1 - offsets[i];
                    }
                } else if (p1 != -1) {
                    offsets[i] = targetSpan - p1 - spans[i];
                }
            } else if (pos.type == 1) {
                if (p0 != -1) {
                    int n = i;
                    offsets[n] = offsets[n] + p0;
                    if (p1 != -1) {
                        spans[i] = spans[i] - p0 - p1 - offsets[i];
                    }
                } else if (p1 != -1) {
                    int n = i;
                    offsets[n] = offsets[n] - p1;
                }
            }
        }
    }

    public void paint(Graphics g, Shape a) {
        Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.painter.paint(g, rect.x, rect.y, rect.width, rect.height, this);
        super.paint(g, a);
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    public int getResizeWeight(int axis) throws IllegalArgumentException {
        if (axis == 1) {
            return 0;
        }
        if (axis == 0) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getAlignment(int axis) {
        if (axis == 0) {
            return super.getAlignment(axis);
        }
        if (axis == 1) {
            if (this.getViewCount() == 0) {
                return 0.0f;
            }
            float prefHeight = this.getPreferredSpan(1);
            View first = this.getView(0);
            float firstRowHeight = first.getPreferredSpan(1);
            return prefHeight != 0.0f ? firstRowHeight * first.getAlignment(1) / prefHeight : 0.0f;
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public void changedUpdate(DocumentEvent ev, Shape a, ViewFactory f) {
        super.changedUpdate(ev, a, f);
        int currPos = ev.getOffset();
        if (currPos <= this.getStartOffset() && currPos + ev.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }

    public float getPreferredSpan(int axis) throws IllegalArgumentException {
        if (axis == 0 || axis == 1) {
            return super.getPreferredSpan(axis);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getMinimumSpan(int axis) throws IllegalArgumentException {
        if (axis == 0 || axis == 1) {
            return super.getMinimumSpan(axis);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getMaximumSpan(int axis) throws IllegalArgumentException {
        if (axis == 0 || axis == 1) {
            return super.getMaximumSpan(axis);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet ss = this.getStyleSheet();
        this.attributes = ss.getViewAttributes(this);
        this.painter = ss.getBoxPainter(this.attributes);
        if (this.attributes != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
        float emBase = ss.getEMBase(this.attributes);
        float exBase = ss.getEXBase(this.attributes);
        this.cssSpans[0] = (Length)this.attributes.getAttribute(CSS.Attribute.WIDTH);
        if (this.cssSpans[0] != null) {
            this.cssSpans[0].setFontBases(emBase, exBase);
        }
        this.cssSpans[1] = (Length)this.attributes.getAttribute(CSS.Attribute.HEIGHT);
        if (this.cssSpans[1] != null) {
            this.cssSpans[1].setFontBases(emBase, exBase);
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    public void replace(int offset, int length, View[] views) {
        int i = 0;
        while (i < length) {
            View child = this.getView(i + offset);
            this.positionInfo.remove(child);
            ++i;
        }
        super.replace(offset, length, views);
        i = 0;
        while (i < views.length) {
            this.fetchLayoutInfo(views[i]);
            ++i;
        }
    }

    private void fetchLayoutInfo(View view) {
        int type;
        AttributeSet atts = view.getAttributes();
        Object o = atts.getAttribute(CSS.Attribute.POSITION);
        if (o != null && o instanceof String && !o.equals("static") && (type = o.equals("relative") ? 1 : (o.equals("absolute") ? 2 : (o.equals("fixed") ? 3 : 0))) != 0) {
            Length bottom;
            Length top;
            Length right;
            StyleSheet ss = this.getStyleSheet();
            float emBase = ss.getEMBase(atts);
            float exBase = ss.getEXBase(atts);
            Length left = (Length)atts.getAttribute(CSS.Attribute.LEFT);
            if (left != null) {
                left.setFontBases(emBase, exBase);
            }
            if ((right = (Length)atts.getAttribute(CSS.Attribute.RIGHT)) != null) {
                right.setFontBases(emBase, exBase);
            }
            if ((top = (Length)atts.getAttribute(CSS.Attribute.TOP)) != null) {
                top.setFontBases(emBase, exBase);
            }
            if ((bottom = (Length)atts.getAttribute(CSS.Attribute.BOTTOM)) != null) {
                bottom.setFontBases(emBase, exBase);
            }
            if (left != null || right != null || top != null || bottom != null) {
                PositionInfo pos = new PositionInfo(type, left, right, top, bottom);
                this.positionInfo.put(view, pos);
            }
        }
    }

    private static class PositionInfo {
        static final int STATIC = 0;
        static final int RELATIVE = 1;
        static final int ABSOLUTE = 2;
        static final int FIXED = 3;
        int type;
        Length left;
        Length right;
        Length top;
        Length bottom;

        PositionInfo(int typ, Length l, Length r, Length t, Length b) {
            this.type = typ;
            this.left = l;
            this.right = r;
            this.top = t;
            this.bottom = b;
        }
    }
}

