/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int GoodBreakWeight = 1000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private Element elt;
    private View parent;

    public View(Element elem) {
        this.elt = elem;
    }

    public abstract void paint(Graphics var1, Shape var2);

    public void setParent(View parent) {
        if (parent == null) {
            int numChildren = this.getViewCount();
            int i = 0;
            while (i < numChildren) {
                View child = this.getView(i);
                if (child.getParent() == this) {
                    child.setParent(null);
                }
                ++i;
            }
        }
        this.parent = parent;
    }

    public View getParent() {
        return this.parent;
    }

    public Container getContainer() {
        View parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getContainer();
    }

    public Document getDocument() {
        return this.getElement().getDocument();
    }

    public Element getElement() {
        return this.elt;
    }

    public abstract float getPreferredSpan(int var1);

    public int getResizeWeight(int axis) {
        return 0;
    }

    public float getMaximumSpan(int axis) {
        float max = 2.1474836E9f;
        if (this.getResizeWeight(axis) <= 0) {
            max = this.getPreferredSpan(axis);
        }
        return max;
    }

    public float getMinimumSpan(int axis) {
        float min = 0.0f;
        if (this.getResizeWeight(axis) <= 0) {
            min = this.getPreferredSpan(axis);
        }
        return min;
    }

    public void setSize(float width, float height) {
    }

    public float getAlignment(int axis) {
        return 0.5f;
    }

    public AttributeSet getAttributes() {
        return this.getElement().getAttributes();
    }

    public boolean isVisible() {
        return true;
    }

    public int getViewCount() {
        return 0;
    }

    public View getView(int index) {
        return null;
    }

    public ViewFactory getViewFactory() {
        View parent = this.getParent();
        return parent != null ? parent.getViewFactory() : null;
    }

    public void replace(int offset, int length, View[] views) {
    }

    public void insert(int offset, View view) {
        View[] array = new View[]{view};
        this.replace(offset, 1, array);
    }

    public void append(View view) {
        View[] array = new View[]{view};
        int offset = this.getViewCount();
        this.replace(offset, 0, array);
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), null);
    }

    public void remove(int index) {
        this.replace(index, 1, null);
    }

    public View createFragment(int p0, int p1) {
        return this;
    }

    public int getStartOffset() {
        return this.getElement().getStartOffset();
    }

    public int getEndOffset() {
        return this.getElement().getEndOffset();
    }

    public Shape getChildAllocation(int index, Shape a) {
        return null;
    }

    public int getViewIndex(float x, float y, Shape allocation) {
        return -1;
    }

    public String getToolTipText(float x, float y, Shape allocation) {
        int index = this.getViewIndex(x, y, allocation);
        String text = null;
        if (index >= 0) {
            Rectangle r;
            Rectangle rectangle = r = (allocation = this.getChildAllocation(index, allocation)) instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            if (r.contains(x, y)) {
                text = this.getView(index).getToolTipText(x, y, allocation);
            }
        }
        return text;
    }

    public Graphics getGraphics() {
        return this.getContainer().getGraphics();
    }

    public void preferenceChanged(View child, boolean width, boolean height) {
        View p = this.getParent();
        if (p != null) {
            p.preferenceChanged(this, width, height);
        }
    }

    public int getBreakWeight(int axis, float pos, float len) {
        int weight = 0;
        if (len > this.getPreferredSpan(axis)) {
            weight = 1000;
        }
        return weight;
    }

    public View breakView(int axis, int offset, float pos, float len) {
        return this;
    }

    public int getViewIndex(int pos, Position.Bias b) {
        return -1;
    }

    public void insertUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        if (this.getViewCount() > 0) {
            Element el = this.getElement();
            DocumentEvent.ElementChange ec = ev.getChange(el);
            if (ec != null && !this.updateChildren(ec, ev, vf)) {
                ec = null;
            }
            this.forwardUpdate(ec, ev, shape, vf);
            this.updateLayout(ec, ev, shape);
        }
    }

    public void removeUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        Element el = this.getElement();
        DocumentEvent.ElementChange ec = ev.getChange(el);
        if (ec != null && !this.updateChildren(ec, ev, vf)) {
            ec = null;
        }
        this.forwardUpdate(ec, ev, shape, vf);
        this.updateLayout(ec, ev, shape);
    }

    public void changedUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        if (this.getViewCount() > 0) {
            Element el = this.getElement();
            DocumentEvent.ElementChange ec = ev.getChange(el);
            if (ec != null && !this.updateChildren(ec, ev, vf)) {
                ec = null;
            }
            this.forwardUpdate(ec, ev, shape, vf);
            this.updateLayout(ec, ev, shape);
        }
    }

    protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent ev, ViewFactory vf) {
        Element[] added = ec.getChildrenAdded();
        Element[] removed = ec.getChildrenRemoved();
        int index = ec.getIndex();
        View[] newChildren = null;
        if (added != null) {
            newChildren = new View[added.length];
            int i = 0;
            while (i < added.length) {
                newChildren[i] = vf.create(added[i]);
                ++i;
            }
        }
        int numRemoved = removed != null ? removed.length : 0;
        this.replace(index, numRemoved, newChildren);
        return true;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent ev, Shape shape, ViewFactory vf) {
        int count = this.getViewCount();
        if (count > 0) {
            Element[] added;
            int startAdded;
            View v;
            int startOffset = ev.getOffset();
            int startIndex = this.getViewIndex(startOffset, Position.Bias.Backward);
            if (startIndex == -1 && ev.getType() == DocumentEvent.EventType.REMOVE && startOffset >= this.getEndOffset()) {
                startIndex = this.getViewCount() - 1;
            }
            if (startIndex >= 0 && (v = this.getView(startIndex)) != null && v.getStartOffset() == startOffset && startOffset > 0) {
                startIndex = Math.max(0, startIndex - 1);
            }
            int endIndex = startIndex = Math.max(0, startIndex);
            if (ev.getType() != DocumentEvent.EventType.REMOVE && (endIndex = this.getViewIndex(startOffset + ev.getLength(), Position.Bias.Forward)) < 0) {
                endIndex = this.getViewCount() - 1;
            }
            int endAdded = startAdded = endIndex + 1;
            Element[] elementArray = added = ec != null ? ec.getChildrenAdded() : null;
            if (added != null && added.length > 0) {
                startAdded = ec.getIndex();
                endAdded = startAdded + added.length - 1;
            }
            int i = startIndex;
            while (i <= endIndex) {
                View child;
                if ((i < startAdded || i > endAdded) && (child = this.getView(i)) != null) {
                    Shape childAlloc = this.getChildAllocation(i, shape);
                    this.forwardUpdateToView(child, ev, childAlloc, vf);
                }
                ++i;
            }
        }
    }

    protected void forwardUpdateToView(View view, DocumentEvent ev, Shape shape, ViewFactory vf) {
        DocumentEvent.EventType type = ev.getType();
        if (type == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(ev, shape, vf);
        } else if (type == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(ev, shape, vf);
        } else if (type == DocumentEvent.EventType.CHANGE) {
            view.changedUpdate(ev, shape, vf);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent ev, Shape shape) {
        if (ec != null && shape != null) {
            this.preferenceChanged(null, true, true);
            Container c = this.getContainer();
            if (c != null) {
                c.repaint();
            }
        }
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public Shape modelToView(int p1, Position.Bias b1, int p2, Position.Bias b2, Shape a) throws BadLocationException {
        Rectangle r2;
        Shape s2;
        if (b1 != Position.Bias.Forward && b1 != Position.Bias.Backward) {
            throw new IllegalArgumentException("b1 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        if (b2 != Position.Bias.Forward && b2 != Position.Bias.Backward) {
            throw new IllegalArgumentException("b2 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        Shape s1 = this.modelToView(p1, a, b1);
        if (p2 != this.getEndOffset()) {
            s2 = this.modelToView(p2, a, b2);
        } else {
            try {
                s2 = this.modelToView(p2, a, b2);
            }
            catch (BadLocationException badLocationException) {
                Rectangle aRect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s2 = new Rectangle(aRect.x + aRect.width - 1, aRect.y, 1, aRect.height);
            }
        }
        Rectangle r1 = s1.getBounds();
        Rectangle rectangle = r2 = s2 instanceof Rectangle ? (Rectangle)s2 : s2.getBounds();
        if (r1.y != r2.y) {
            Rectangle aRect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r1.x = aRect.x;
            r1.width = aRect.width;
        }
        return SwingUtilities.computeUnion(r2.x, r2.y, r2.width, r2.height, r1);
    }

    public Shape modelToView(int pos, Shape a) throws BadLocationException {
        return this.modelToView(pos, a, Position.Bias.Forward);
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public int viewToModel(float x, float y, Shape a) {
        Position.Bias[] biasRet = new Position.Bias[]{Position.Bias.Forward};
        return this.viewToModel(x, y, a, biasRet);
    }

    protected void dump() {
        View parent = this.getParent();
        if (parent != null) {
            parent.dump();
        } else {
            this.dump(0);
        }
    }

    void dump(int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print('.');
            ++i;
        }
        System.out.println(this + "(" + this.getStartOffset() + "," + this.getEndOffset() + ": " + this.getElement());
        int count = this.getViewCount();
        int i2 = 0;
        while (i2 < count) {
            this.getView(i2).dump(indent + 1);
            ++i2;
        }
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int d, Position.Bias[] biasRet) throws BadLocationException {
        int ret = pos;
        switch (d) {
            case 3: {
                ret = Math.min(pos + 1, this.getEndOffset());
                break;
            }
            case 7: {
                ret = Math.max(pos - 1, this.getStartOffset());
                break;
            }
            case 1: {
                View parent = this.getParent();
                Rectangle r = parent.modelToView(pos, a, b).getBounds();
                ret = parent.viewToModel(r.x, r.y - 1, a, biasRet);
                break;
            }
            case 5: {
                View parent = this.getParent();
                Rectangle r = parent.modelToView(pos, a, b).getBounds();
                ret = parent.viewToModel(r.x + r.width, r.y + r.height, a, biasRet);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for d");
            }
        }
        return ret;
    }
}

