/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGGamma;
import gnu.javax.imageio.png.PNGHeader;
import gnu.javax.imageio.png.PNGICCProfile;
import gnu.javax.imageio.png.PNGPalette;
import gnu.javax.imageio.png.PNGPhys;
import gnu.javax.imageio.png.PNGTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PNGChunk {
    private static long[] crcTable = new long[256];
    public static final int TYPE_HEADER = 1229472850;
    public static final int TYPE_PALETTE = 1347179589;
    public static final int TYPE_DATA = 1229209940;
    public static final int TYPE_TIME = 1950960965;
    public static final int TYPE_END = 1229278788;
    public static final int TYPE_PHYS = 1883789683;
    public static final int TYPE_GAMMA = 1732332865;
    public static final int TYPE_PROFILE = 1766015824;
    private int type;
    protected byte[] data;
    private int crc;

    static {
        int i = 0;
        while (i < 256) {
            long c = i;
            int j = 0;
            while (j < 8) {
                c = (c & 1L) == 1L ? 0xEDB88320L ^ c >> 1 : (c >>= 1);
                ++j;
            }
            PNGChunk.crcTable[i] = c;
            ++i;
        }
    }

    protected PNGChunk(int type, byte[] data, int crc) {
        this.type = type;
        this.data = data;
        this.crc = crc;
    }

    protected PNGChunk(int type) {
        this.type = type;
    }

    public static PNGChunk readChunk(InputStream in, boolean strict) throws IOException, PNGException {
        byte[] data = new byte[4];
        if (in.read(data) != 4) {
            throw new IOException("Could not read chunk length.");
        }
        int length = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        if (in.read(data) != 4) {
            throw new IOException("Could not read chunk type.");
        }
        int type = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        byte[] chkdata = new byte[length];
        if (in.read(chkdata) != length) {
            throw new IOException("Could not read chunk data.");
        }
        if (in.read(data) != 4) {
            throw new IOException("Could not read chunk CRC.");
        }
        int crc = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        if (strict) {
            return PNGChunk.getChunk(type, chkdata, crc);
        }
        try {
            return PNGChunk.getChunk(type, chkdata, crc);
        }
        catch (PNGException pnge) {
            if (PNGChunk.isEssentialChunk(type)) {
                throw pnge;
            }
            return null;
        }
    }

    private static PNGChunk getChunk(int type, byte[] data, int crc) throws PNGException {
        switch (type) {
            case 1229472850: {
                return new PNGHeader(type, data, crc);
            }
            case 1229209940: {
                return new PNGData(type, data, crc);
            }
            case 1347179589: {
                return new PNGPalette(type, data, crc);
            }
            case 1950960965: {
                return new PNGTime(type, data, crc);
            }
            case 1883789683: {
                return new PNGPhys(type, data, crc);
            }
            case 1732332865: {
                return new PNGGamma(type, data, crc);
            }
            case 1766015824: {
                return new PNGICCProfile(type, data, crc);
            }
        }
        return new PNGChunk(type, data, crc);
    }

    private static boolean isEssentialChunk(int type) {
        switch (type) {
            case 1229209940: 
            case 1229278788: 
            case 1229472850: 
            case 1347179589: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidChunk() {
        return this.crc == this.calcCRC();
    }

    public int getType() {
        return this.type;
    }

    public void writeChunk(OutputStream out) throws IOException {
        out.write(PNGChunk.getInt(this.data.length));
        out.write(PNGChunk.getInt(this.type));
        out.write(this.data);
        out.write(PNGChunk.getInt(this.calcCRC()));
    }

    public boolean isEmpty() {
        return this.data.length == 0;
    }

    public static byte[] getInt(int intValue) {
        long i = (long)intValue & 0xFFFFFFFFL;
        byte[] b = new byte[]{(byte)((i & 0xFF000000L) >> 24), (byte)((i & 0xFF0000L) >> 16), (byte)((i & 0xFF00L) >> 8), (byte)(i & 0xFFL)};
        return b;
    }

    private int calcCRC() {
        long c = 0xFFFFFFFFL;
        byte[] t = PNGChunk.getInt(this.type);
        int i = 0;
        while (i < 4) {
            c = crcTable[(int)((c ^ (long)t[i]) & 0xFFL)] ^ c >> 8;
            ++i;
        }
        i = 0;
        while (i < this.data.length) {
            c = crcTable[(int)((c ^ (long)this.data[i]) & 0xFFL)] ^ c >> 8;
            ++i;
        }
        return (int)(c ^ 0xFFFFFFFFL);
    }

    public String toString() {
        return "PNG Chunk. Type: " + new String(PNGChunk.getInt(this.type)) + " , CRC: " + this.crc + " , calculated CRC: " + this.calcCRC();
    }
}

