/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkClipboardNotifier;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkSelection;
import gnu.java.lang.CPStringBuilder;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public class GtkClipboard
extends Clipboard {
    static final GtkClipboard clipboard = new GtkClipboard("System Clipboard");
    static final GtkClipboard selection = new GtkClipboard("System Selection");
    static final String stringMimeType = DataFlavor.stringFlavor.getMimeType();
    static final String imageMimeType = DataFlavor.imageFlavor.getMimeType();
    static final String filesMimeType = DataFlavor.javaFileListFlavor.getMimeType();
    static final boolean canCache = GtkClipboard.initNativeState(clipboard, selection, stringMimeType, imageMimeType, filesMimeType);

    private GtkClipboard(String name) {
        super(name);
        this.setContents(new GtkSelection(this), null);
    }

    static GtkClipboard getClipboardInstance() {
        return clipboard;
    }

    static GtkClipboard getSelectionInstance() {
        return selection;
    }

    private synchronized void setSystemContents(boolean cleared) {
        boolean needNotification;
        boolean owner = !(this.contents instanceof GtkSelection);
        boolean bl = needNotification = cleared && owner || !cleared && !owner;
        if (needNotification) {
            GtkClipboardNotifier.announce(this);
        }
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        super.setContents(contents, owner);
        if (contents == null) {
            this.advertiseContent(null, false, false, false);
            return;
        }
        if (contents instanceof GtkSelection) {
            return;
        }
        boolean text = false;
        boolean images = false;
        boolean files = false;
        if (contents instanceof StringSelection || contents.isDataFlavorSupported(DataFlavor.stringFlavor) || contents.isDataFlavorSupported(DataFlavor.plainTextFlavor) || contents.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
            text = true;
        }
        DataFlavor[] flavors = contents.getTransferDataFlavors();
        String[] mimeTargets = new String[flavors.length];
        int i = 0;
        while (i < flavors.length) {
            String mimeType;
            DataFlavor flavor = flavors[i];
            mimeTargets[i] = mimeType = flavor.getMimeType();
            if (!text && ("text".equals(flavor.getPrimaryType()) || flavor.isRepresentationClassReader())) {
                text = true;
            }
            if (!images && flavors[i].equals(DataFlavor.imageFlavor)) {
                try {
                    Object o = contents.getTransferData(DataFlavor.imageFlavor);
                    if (o instanceof Image) {
                        images = true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                }
                catch (ClassCastException classCastException) {}
            }
            if (flavors[i].equals(DataFlavor.javaFileListFlavor)) {
                files = true;
            }
            ++i;
        }
        this.advertiseContent(mimeTargets, text, images, files);
    }

    private native void advertiseContent(String[] var1, boolean var2, boolean var3, boolean var4);

    private String provideText() {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        if (contents instanceof StringSelection) {
            try {
                return (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
            }
            catch (ClassCastException classCastException) {}
        }
        try {
            DataFlavor plainText = DataFlavor.getTextPlainUnicodeFlavor();
            Reader r = plainText.getReaderForText(contents);
            if (r != null) {
                CPStringBuilder sb = new CPStringBuilder();
                char[] cs = new char[1024];
                int l = r.read(cs);
                while (l != -1) {
                    sb.append(cs, 0, l);
                    l = r.read(cs);
                }
                return sb.toString();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private GtkImage provideImage() {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        try {
            Object o = contents.getTransferData(DataFlavor.imageFlavor);
            if (o instanceof GtkImage) {
                return (GtkImage)o;
            }
            return new GtkImage(((Image)o).getSource());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    private String[] provideURIs() {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        try {
            List list2 = (List)contents.getTransferData(DataFlavor.javaFileListFlavor);
            String[] uris = new String[list2.size()];
            int u = 0;
            Iterator it = list2.iterator();
            while (it.hasNext()) {
                uris[u++] = ((File)it.next()).toURI().toString();
            }
            return uris;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    private byte[] provideContent(String target) {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        try {
            DataFlavor flavor = new DataFlavor(target);
            Object o = contents.getTransferData(flavor);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            if (o instanceof InputStream) {
                InputStream is = (InputStream)o;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bs = new byte[1024];
                int l = is.read(bs);
                while (l != -1) {
                    baos.write(bs, 0, l);
                    l = is.read(bs);
                }
                return baos.toByteArray();
            }
            if (o instanceof Serializable) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
                oos.close();
                return baos.toByteArray();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    private static native boolean initNativeState(GtkClipboard var0, GtkClipboard var1, String var2, String var3, String var4);
}

