#!/bin/sh
echo 'name: feldspar-language
version: 0.6.0.2
id: feldspar-language-0.6.0.2-db0af8d3536bb139f443858439f56371

license: BSD3
copyright: Copyright (c) 2012 Emil Axelsson, Gergely Dévai,
           Anders Persson, Josef Svenningsson
           Copyright (c) 2009-2011, ERICSSON AB
maintainer: Emil Axelsson <emax@chalmers.se>
            Anders Persson <anders.cj.persson@gmail.com>
stability: experimental
homepage: https://feldspar.github.com
package-url:
synopsis: A functional embedded language for DSP and parallelism
description: Feldspar (Functional Embedded Language for DSP and PARallelism)
             is an embedded DSL for describing digital signal processing
             algorithms. This package contains the language front-end and an
             interpreter.
category: Language
author: Functional programming group at Chalmers University of Technology
pkgpath: lang/feldspar/language
exposed: True
exposed-modules: Feldspar.Prelude Feldspar.Lattice Feldspar.Range
                 Feldspar.Algorithm.CRC Feldspar.Algorithm.FFT Feldspar.Core.Types
                 Feldspar.Core.Interpretation Feldspar.Core.Interpretation.Typed
                 Feldspar.Core.Constructs.Array Feldspar.Core.Constructs.Binding
                 Feldspar.Core.Constructs.Bits Feldspar.Core.Constructs.Complex
                 Feldspar.Core.Constructs.Condition
                 Feldspar.Core.Constructs.ConditionM
                 Feldspar.Core.Constructs.Conversion Feldspar.Core.Constructs.Eq
                 Feldspar.Core.Constructs.Error Feldspar.Core.Constructs.Floating
                 Feldspar.Core.Constructs.Fractional Feldspar.Core.Constructs.Future
                 Feldspar.Core.Constructs.Integral Feldspar.Core.Constructs.Literal
                 Feldspar.Core.Constructs.Logic Feldspar.Core.Constructs.Loop
                 Feldspar.Core.Constructs.Mutable
                 Feldspar.Core.Constructs.MutableArray
                 Feldspar.Core.Constructs.MutableReference
                 Feldspar.Core.Constructs.MutableToPure
                 Feldspar.Core.Constructs.NoInline Feldspar.Core.Constructs.Par
                 Feldspar.Core.Constructs.Num Feldspar.Core.Constructs.Ord
                 Feldspar.Core.Constructs.SizeProp
                 Feldspar.Core.Constructs.SourceInfo Feldspar.Core.Constructs.Trace
                 Feldspar.Core.Constructs.Tuple Feldspar.Core.Constructs.FFI
                 Feldspar.Core.Constructs.Save Feldspar.Core.Constructs
                 Feldspar.Core.Frontend.Array Feldspar.Core.Frontend.Binding
                 Feldspar.Core.Frontend.Bits Feldspar.Core.Frontend.Complex
                 Feldspar.Core.Frontend.Condition Feldspar.Core.Frontend.ConditionM
                 Feldspar.Core.Frontend.Conversion Feldspar.Core.Frontend.Eq
                 Feldspar.Core.Frontend.Error Feldspar.Core.Frontend.Floating
                 Feldspar.Core.Frontend.Fractional Feldspar.Core.Frontend.Future
                 Feldspar.Core.Frontend.Integral Feldspar.Core.Frontend.Literal
                 Feldspar.Core.Frontend.Logic Feldspar.Core.Frontend.Loop
                 Feldspar.Core.Frontend.Mutable Feldspar.Core.Frontend.MutableArray
                 Feldspar.Core.Frontend.MutableReference
                 Feldspar.Core.Frontend.MutableToPure
                 Feldspar.Core.Frontend.NoInline Feldspar.Core.Frontend.Par
                 Feldspar.Core.Frontend.Num Feldspar.Core.Frontend.Ord
                 Feldspar.Core.Frontend.Select Feldspar.Core.Frontend.SizeProp
                 Feldspar.Core.Frontend.SourceInfo Feldspar.Core.Frontend.Trace
                 Feldspar.Core.Frontend.Tuple Feldspar.Core.Frontend.FFI
                 Feldspar.Core.Frontend.Save Feldspar.Core.Frontend
                 Feldspar.Core.Collection Feldspar.Core Feldspar.BitVector
                 Feldspar.FixedPoint Feldspar.Future Feldspar.Matrix Feldspar.Option
                 Feldspar.Repa Feldspar.Stream Feldspar.Vector.Internal
                 Feldspar.Vector Feldspar.Vector.Push Feldspar.Wrap Feldspar.Par
                 Feldspar
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
library-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
hs-libraries: HSfeldspar-language-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: QuickAnnotate-0.6-de6a96240cbe34d04184955755dfb077
         QuickCheck-2.5.1.1-4b3daf6f1579962bcef10ad37634c8ea
         array-0.4.0.0-4f6c2a594155b0b953c1cf0f54040f61
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         data-hash-0.1.0.0-352bb8bc936f31e81fe7d265a35e3ab2
         data-lens-2.10.2-aff0068d7424ba9a158573b618eb4d7a
         monad-par-0.3-4bc8e0ab06cc90b84ed961006bf51e08
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         patch-combinators-0.1-5c9078b9c16478220d92246a0a63181f
         syntactic-1.4-5d0ac047fcc0191c81887a88cebbd33d
         tagged-0.4.4-55c603ce43bd5a4d0399cb94469b9536
         tuple-0.2.0.1-5849de90ca5f385508091ea1a44778a5
         type-level-0.2.4-e65b212fde5e6079d34961c86e17728b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html/feldspar-language.haddock
haddock-html: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
