#!/bin/sh
echo 'name: feldspar-compiler
version: 0.6.0.2
id: feldspar-compiler-0.6.0.2-f185b9773cb4477c3a0a239c0057e427

license: BSD3
copyright: Copyright (c) 2012 Emil Axelsson, Gergely Dévai,
           Anders Persson, Josef Svenningsson
           Copyright (c) 2009-2011, ERICSSON AB
maintainer: deva@inf.elte.hu
stability: experimental
homepage: https://feldspar.github.com
package-url:
synopsis: Compiler for the Feldspar language
description: Feldspar (**F**unctional **E**mbedded **L**anguage for **DSP**
             and **PAR**allelism) is an embedded DSL for describing digital
             signal processing algorithms.
             This library (FeldsparCompiler) contains a prototype compiler
             that supports C code generation from programs written in this
             language both according to ANSI C and also targeted to a real
             DSP HW.
category: Compiler
author: Feldspar group,
        Eotvos Lorand University Faculty of Informatics
pkgpath: lang/feldspar/compiler
exposed: True
exposed-modules: Feldspar.Compiler.Imperative.Representation
                 Feldspar.Compiler.Imperative.FromCore
                 Feldspar.Compiler.Imperative.FromCore.Array
                 Feldspar.Compiler.Imperative.FromCore.Binding
                 Feldspar.Compiler.Imperative.FromCore.Condition
                 Feldspar.Compiler.Imperative.FromCore.ConditionM
                 Feldspar.Compiler.Imperative.FromCore.Error
                 Feldspar.Compiler.Imperative.FromCore.Future
                 Feldspar.Compiler.Imperative.FromCore.Interpretation
                 Feldspar.Compiler.Imperative.FromCore.Literal
                 Feldspar.Compiler.Imperative.FromCore.Loop
                 Feldspar.Compiler.Imperative.FromCore.Mutable
                 Feldspar.Compiler.Imperative.FromCore.MutableToPure
                 Feldspar.Compiler.Imperative.FromCore.NoInline
                 Feldspar.Compiler.Imperative.FromCore.Par
                 Feldspar.Compiler.Imperative.FromCore.Primitive
                 Feldspar.Compiler.Imperative.FromCore.SizeProp
                 Feldspar.Compiler.Imperative.FromCore.SourceInfo
                 Feldspar.Compiler.Imperative.FromCore.Tuple
                 Feldspar.Compiler.Imperative.FromCore.FFI
                 Feldspar.Compiler.Imperative.FromCore.Save
                 Feldspar.Compiler.Imperative.Frontend
                 Feldspar.Compiler.Imperative.TransformationInstance
                 Feldspar.Compiler.Imperative.Plugin.CollectFreeVars
                 Feldspar.Compiler.Imperative.Plugin.ConstantFolding
                 Feldspar.Compiler.Imperative.Plugin.Free
                 Feldspar.Compiler.Imperative.Plugin.IVars
                 Feldspar.Compiler.Imperative.Plugin.Unroll
                 Feldspar.Compiler.Imperative.Plugin.Naming
                 Feldspar.Compiler.Backend.C.CodeGeneration
                 Feldspar.Compiler.Backend.C.Plugin.PrettyPrint
                 Feldspar.Compiler.Backend.C.Plugin.Locator
                 Feldspar.Compiler.Backend.C.Plugin.BlockProgramHandler
                 Feldspar.Compiler.Backend.C.Plugin.TypeCorrector
                 Feldspar.Compiler.Backend.C.Plugin.TypeDefinitionGenerator
                 Feldspar.Compiler.Backend.C.Plugin.VariableRoleAssigner
                 Feldspar.Compiler.Backend.C.Plugin.Rule
                 Feldspar.Compiler.Backend.C.Library
                 Feldspar.Compiler.Backend.C.Options
                 Feldspar.Compiler.Backend.C.Platforms
                 Feldspar.Compiler.Frontend.Interactive.Interface
                 Feldspar.Compiler.Compiler Feldspar.Compiler.Error
                 Feldspar.Compiler Feldspar.Transformation
                 Feldspar.Transformation.Framework Feldspar.NameExtractor
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2
library-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2
hs-libraries: HSfeldspar-compiler-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2/include
includes:
depends: MonadCatchIO-mtl-0.3.0.5-8901559f8f89c3c3946fdd839ae54ae8
         ansi-terminal-0.5.5-8801f5127d93c5faa91ff9c937224633
         base-4.5.1.0-5b1c9d3d412ed227632edae6d2aca151
         containers-0.4.2.1-efa59805336a77490296ae3897cecb87
         directory-1.1.0.2-4b2070a8941d5c76e41241a2ac457927
         feldspar-language-0.6.0.2-db0af8d3536bb139f443858439f56371
         filepath-1.3.0.0-954c43b4f109cbd4121f1231c14d5cff
         haskell-src-exts-1.13.3-f45fa602e1b8c81a4df3ebfd09086435
         mtl-2.1.2-cf6082d8d4c6758d23401302efadd028
         process-1.1.0.1-c55e7a2b0eb5149f070b14e14bea1c83
         syntactic-1.4-5d0ac047fcc0191c81887a88cebbd33d
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-feldspar-compiler-0.6.0.2/html/feldspar-compiler.haddock
haddock-html: /usr/local/share/doc/hs-feldspar-compiler-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
