(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Apr 30 17:15:58 PDT 1993 by swart *)
INTERFACE Capability;

IMPORT TimeStamp;

TYPE
  T = RECORD
        ts    : TimeStamp.T;
        random: ARRAY [0 .. 7] OF BITS 8 FOR [0 .. 255];
      END;

    (* Each Capability.T generated is unique globally and can be guessed
      by an adversary only with very low probability.  *)

PROCEDURE New(): T;
  (* Returns a new Capability.T *)

PROCEDURE Equal(READONLY t1, t2: T): BOOLEAN;
  (* Returns TRUE if the two capabilities were generated by the same
     call  to New.  Equivalent to "=" for use by generic modules. *)

PROCEDURE Hash(READONLY t: T): INTEGER;
  (* Returns a hash function of the capability usable by generic table
     packages.  Note that unlike some other hash functions this
     hash function is invariant over byte order and word size.  As
     such the return value is always such that it fits in the 32
     bit integer. *)

END Capability.
