/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.pde.internal.ui;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenPDEPerspectiveAction extends Action {
	public OpenPDEPerspectiveAction() {
	}

	public void run() {
		IWorkbenchWindow window = PDEPlugin.getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
		IAdaptable input;
		if (page != null)
			input = page.getInput();
		else
			input = ResourcesPlugin.getWorkspace().getRoot();
		try {
			PlatformUI.getWorkbench().showPerspective(
				"org.eclipse.pde.ui.PDEPerspective", //$NON-NLS-1$
				window,
				input);
			notifyResult(true);
			
		} catch (WorkbenchException e) {
			PDEPlugin.logException(e);
			notifyResult(false);
		}
	}
}
