/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.XMLContentDescriber;
import org.eclipse.core.internal.content.XMLRootHandler;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLRootElementContentDescriber
extends XMLContentDescriber
implements IExecutableExtension {
    private static final String DTD_TO_FIND = "dtd";
    private static final String ELEMENT_TO_FIND = "element";
    private String dtdToFind = null;
    private String elementToFind = null;

    private int checkCriteria(InputSource contents) throws IOException {
        XMLRootHandler xmlHandler = new XMLRootHandler(this.elementToFind != null);
        try {
            if (!xmlHandler.parseContents(contents)) {
                return 1;
            }
        }
        catch (SAXException sAXException) {
            return 1;
        }
        catch (ParserConfigurationException e) {
            String message = ContentMessages.content_parserConfiguration;
            RuntimeLog.log((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, message, (Throwable)e));
            throw new RuntimeException(message);
        }
        if (this.elementToFind != null && !this.elementToFind.equals(xmlHandler.getRootName())) {
            return 1;
        }
        if (this.dtdToFind != null && !this.dtdToFind.equals(xmlHandler.getDTD())) {
            return 1;
        }
        return 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.elementToFind = (String)data;
        } else if (data instanceof Hashtable) {
            Hashtable parameters = (Hashtable)data;
            this.dtdToFind = (String)parameters.get(DTD_TO_FIND);
            this.elementToFind = (String)parameters.get(ELEMENT_TO_FIND);
        }
        if (this.dtdToFind == null && this.elementToFind == null) {
            String message = NLS.bind((String)ContentMessages.content_badInitializationData, (Object)XMLRootElementContentDescriber.class.getName());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, message, null));
        }
    }
}

