/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IWorkbenchPart;

public class PresentationContext
implements IPresentationContext {
    private IWorkbenchPart fPart;
    private String[] fColumns;
    private ListenerList fListeners = new ListenerList();

    public PresentationContext(IWorkbenchPart part) {
        this.fPart = part;
    }

    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    public String[] getColumns() {
        return this.fColumns;
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (!this.fListeners.isEmpty()) {
            final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        listener.propertyChange(event);
                    }
                });
                ++i;
            }
        }
    }

    protected void setColumns(String[] ids) {
        String[] oldValue = this.fColumns;
        this.fColumns = ids;
        this.firePropertyChange("PROPERTY_COLUMNS", oldValue, ids);
    }

    protected void dispose() {
        this.fListeners.clear();
        this.fPart = null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }
}

