/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PersistableLaunchConfigurationFactory
implements IPersistableElement,
IElementFactory {
    private ILaunchConfiguration fConfig;
    private static final String KEY = "launchConfigMemento";
    private static final String FACTORY_ID = "org.eclipse.debug.ui.PersistableLaunchConfigurationFactory";

    public PersistableLaunchConfigurationFactory() {
    }

    public PersistableLaunchConfigurationFactory(ILaunchConfiguration config) {
        this.setConfig(config);
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        try {
            String configMemento = this.getConfig().getMemento();
            memento.putString(KEY, configMemento);
        }
        catch (CoreException coreException) {}
    }

    public IAdaptable createElement(IMemento memento) {
        try {
            String launchConfigMemento = memento.getString(KEY);
            return this.getLaunchManager().getLaunchConfiguration(launchConfigMemento);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void setConfig(ILaunchConfiguration config) {
        this.fConfig = config;
    }

    private ILaunchConfiguration getConfig() {
        return this.fConfig;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

