/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;

public class CloseOthersAction
extends PageEventAction {
    public CloseOthersAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.CloseOthersAction_text, window);
        this.setToolTipText(WorkbenchMessages.CloseOthersAction_toolTip);
        this.setEnabled(false);
        this.setId("closeOthers");
        this.updateState();
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.close_others_action_context");
        this.setActionDefinitionId("org.eclipse.ui.file.closeOthers");
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.updateState();
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        this.updateState();
    }

    public void run() {
        IEditorReference[] refArray;
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = this.getActivePage();
        if (page != null && (refArray = page.getEditorReferences()) != null && refArray.length > 1) {
            IEditorReference[] otherEditors = new IEditorReference[refArray.length - 1];
            IEditorReference activeEditor = (IEditorReference)page.getReference(page.getActiveEditor());
            int i = 0;
            while (i < refArray.length) {
                if (refArray[i] == activeEditor) {
                    System.arraycopy(refArray, 0, otherEditors, 0, i);
                    System.arraycopy(refArray, i + 1, otherEditors, i, refArray.length - 1 - i);
                    break;
                }
                ++i;
            }
            page.closeEditors(otherEditors, true);
        }
    }

    private void updateState() {
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            this.setEnabled(page.getEditorReferences().length > 1);
        } else {
            this.setEnabled(false);
        }
    }
}

