/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.MultiTermQuery;

public final class FuzzyQuery
extends MultiTermQuery {
    public static final float defaultMinSimilarity = 0.5f;
    private float minimumSimilarity;
    private int prefixLength;

    public FuzzyQuery(Term term, float minimumSimilarity, int prefixLength) throws IllegalArgumentException {
        super(term);
        if (minimumSimilarity > 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity > 1");
        }
        if (minimumSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity < 0");
        }
        this.minimumSimilarity = minimumSimilarity;
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength < 0");
        }
        if (prefixLength >= term.text().length()) {
            throw new IllegalArgumentException("prefixLength >= term.text().length()");
        }
        this.prefixLength = prefixLength;
    }

    public FuzzyQuery(Term term, float minimumSimilarity) throws IllegalArgumentException {
        this(term, minimumSimilarity, 0);
    }

    public FuzzyQuery(Term term) {
        this(term, 0.5f, 0);
    }

    public float getMinSimilarity() {
        return this.minimumSimilarity;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new FuzzyTermEnum(reader, this.getTerm(), this.minimumSimilarity, this.prefixLength);
    }

    public String toString(String field) {
        return super.toString(field) + '~' + Float.toString(this.minimumSimilarity);
    }
}

