/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.contentassist.TypeContext;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaLineBreakpointPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class BreakpointConditionEditor {
    private JDISourceViewer fViewer;
    private IContentAssistProcessor fCompletionProcessor;
    private String fOldValue;
    private String fErrorMessage;
    private JavaLineBreakpointPage fPage;
    private IJavaLineBreakpoint fBreakpoint;
    private IHandlerService fHandlerService;
    private IHandler fHandler;
    private IHandlerActivation fActivation;
    private IDocumentListener fDocumentListener;

    public BreakpointConditionEditor(Composite parent, JavaLineBreakpointPage page) {
        this.fPage = page;
        this.fBreakpoint = (IJavaLineBreakpoint)this.fPage.getBreakpoint();
        String condition = new String();
        try {
            condition = this.fBreakpoint.getCondition();
            this.fErrorMessage = PropertyPageMessages.BreakpointConditionEditor_1;
            this.fOldValue = "";
            this.fViewer = new JDISourceViewer(parent, null, 2816);
            this.fViewer.setInput(parent);
            Document document = new Document();
            JDIDebugUIPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
            TypeContext context = null;
            IType type = BreakpointUtils.getType((IJavaBreakpoint)this.fBreakpoint);
            if (type == null) {
                context = new TypeContext(null, -1);
            } else {
                try {
                    String source = null;
                    ICompilationUnit compilationUnit = type.getCompilationUnit();
                    if (compilationUnit != null) {
                        source = compilationUnit.getSource();
                    } else {
                        IClassFile classFile = type.getClassFile();
                        if (classFile != null) {
                            source = classFile.getSource();
                        }
                    }
                    int lineNumber = this.fBreakpoint.getMarker().getAttribute("lineNumber", -1);
                    int position = -1;
                    if (source != null && lineNumber != -1) {
                        try {
                            position = new Document(source).getLineOffset(lineNumber - 1);
                        }
                        catch (BadLocationException e) {
                            JDIDebugUIPlugin.log(e);
                        }
                    }
                    context = new TypeContext(type, position);
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            this.fCompletionProcessor = new JavaDebugContentAssistProcessor(context);
            this.fViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

                public IContentAssistProcessor getContentAssistantProcessor() {
                    return BreakpointConditionEditor.this.fCompletionProcessor;
                }
            });
            this.fViewer.setEditable(true);
            document.set(condition);
            this.fViewer.setDocument((IDocument)document);
            this.fViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(10));
            this.fViewer.getUndoManager().connect((ITextViewer)this.fViewer);
            this.fDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    BreakpointConditionEditor.this.valueChanged();
                }
            };
            this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
            GridData gd = new GridData(1808);
            gd.heightHint = this.fPage.convertHeightInCharsToPixels(10);
            gd.widthHint = this.fPage.convertWidthInCharsToPixels(40);
            this.fViewer.getControl().setLayoutData((Object)gd);
            this.fHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    BreakpointConditionEditor.this.fViewer.doOperation(13);
                    return null;
                }
            };
            this.fHandlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        }
        catch (CoreException exception) {
            JDIDebugUIPlugin.log(exception);
        }
    }

    public String getCondition() {
        return this.fViewer.getDocument().get();
    }

    protected void refreshValidState() {
        if (!this.fViewer.isEditable()) {
            this.fPage.removeErrorMessage(this.fErrorMessage);
        } else {
            String text = this.fViewer.getDocument().get();
            if (text == null || text.trim().length() <= 0) {
                this.fPage.addErrorMessage(this.fErrorMessage);
            } else {
                this.fPage.removeErrorMessage(this.fErrorMessage);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        if (enabled) {
            this.fViewer.updateViewerColors();
            this.fViewer.getTextWidget().setFocus();
            this.fActivation = this.fHandlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", this.fHandler);
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
            if (this.fActivation != null) {
                this.fHandlerService.deactivateHandler(this.fActivation);
            }
        }
        this.valueChanged();
    }

    protected void valueChanged() {
        String newValue = this.fViewer.getDocument().get();
        if (!newValue.equals(this.fOldValue)) {
            this.fOldValue = newValue;
        }
        this.refreshValidState();
    }

    public void dispose() {
        if (this.fViewer.isEditable()) {
            this.fHandlerService.deactivateHandler(this.fActivation);
        }
        this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        this.fViewer.dispose();
    }
}

