/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.internal.presentations.SystemMenuClose;
import org.eclipse.ui.internal.presentations.SystemMenuMaximize;
import org.eclipse.ui.internal.presentations.SystemMenuMove;
import org.eclipse.ui.internal.presentations.SystemMenuRestore;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.internal.presentations.r21.R21Colors;
import org.eclipse.ui.internal.presentations.r21.R21PresentationMessages;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolder;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolderEvent;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolderListener;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabItem;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.PresentationUtil;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class R21EditorStackPresentation
extends StackPresentation {
    private CTabFolder tabFolder;
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            Point localPos = new Point(event.x, event.y);
            CTabItem tabUnderPointer = R21EditorStackPresentation.this.tabFolder.getItem(localPos);
            if (tabUnderPointer == null) {
                if (R21EditorStackPresentation.this.getSite().isStackMoveable()) {
                    R21EditorStackPresentation.this.getSite().dragStart(R21EditorStackPresentation.this.tabFolder.toDisplay(localPos), false);
                }
                return;
            }
            IPresentablePart part = R21EditorStackPresentation.this.getPartForTab(tabUnderPointer);
            if (R21EditorStackPresentation.this.getSite().isPartMoveable(part)) {
                R21EditorStackPresentation.this.getSite().dragStart(part, R21EditorStackPresentation.this.tabFolder.toDisplay(localPos), false);
            }
        }
    };
    private CTabFolderListener closeListener = new CTabFolderListener(){

        public void itemClosed(CTabFolderEvent e) {
            CTabItem item = (CTabItem)e.item;
            if (item != null) {
                e.doit = false;
                R21EditorStackPresentation.this.getSite().close(new IPresentablePart[]{R21EditorStackPresentation.this.getPartForTab(item)});
            }
        }
    };
    private IPresentablePart current;
    private MenuManager systemMenuManager = new MenuManager();
    private static IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private static int tabPos = preferenceStore.getInt("EDITOR_TAB_POSITION");
    private static final String TAB_DATA = String.valueOf(R21EditorStackPresentation.class.getName()) + ".partId";
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            if (e.widget instanceof Control) {
                Control ctrl = (Control)e.widget;
                Point globalPos = ctrl.toDisplay(new Point(e.x, e.y));
                CTabItem newItem = R21EditorStackPresentation.this.tabFolder.getItem(R21EditorStackPresentation.this.tabFolder.toControl(globalPos));
                if (newItem != null) {
                    CTabItem oldItem;
                    if (e.button == 1 && R21EditorStackPresentation.overImage(newItem, e.x)) {
                        R21EditorStackPresentation.this.getSite().selectPart(R21EditorStackPresentation.this.getPartForTab(newItem));
                        R21EditorStackPresentation.this.showSystemMenu();
                    }
                    if (newItem != (oldItem = R21EditorStackPresentation.this.tabFolder.getSelection())) {
                        return;
                    }
                }
                if (R21EditorStackPresentation.this.current != null) {
                    R21EditorStackPresentation.this.current.setFocus();
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (R21EditorStackPresentation.this.getSite().getState() == 1) {
                R21EditorStackPresentation.this.getSite().setState(2);
            } else {
                R21EditorStackPresentation.this.getSite().setState(1);
            }
        }
    };
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point pos = new Point(event.x, event.y);
            R21EditorStackPresentation.this.showSystemMenu(pos);
        }
    };
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event e) {
            IPresentablePart item = R21EditorStackPresentation.this.getPartForTab((CTabItem)e.item);
            if (item != null) {
                R21EditorStackPresentation.this.getSite().selectPart(item);
            }
        }
    };
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event e) {
            R21EditorStackPresentation.this.setControlSize();
        }
    };
    private IPropertyListener childPropertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int property) {
            if (source instanceof IPresentablePart) {
                IPresentablePart part = (IPresentablePart)source;
                R21EditorStackPresentation.this.childPropertyChanged(part, property);
            }
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget instanceof CTabItem) {
                CTabItem item = (CTabItem)e.widget;
                IPresentablePart part = R21EditorStackPresentation.this.getPartForTab(item);
                part.removePropertyListener(R21EditorStackPresentation.this.childPropertyChangeListener);
            }
        }
    };
    private ShellAdapter shellListener = new ShellAdapter(){

        public void shellActivated(ShellEvent event) {
            R21EditorStackPresentation.this.updateGradient();
        }

        public void shellDeactivated(ShellEvent event) {
            R21EditorStackPresentation.this.updateGradient();
        }
    };
    private int activeState = 0;

    static boolean overImage(CTabItem item, int x) {
        Rectangle imageBounds = item.getImage().getBounds();
        return x < item.getBounds().x + imageBounds.x + imageBounds.width;
    }

    public R21EditorStackPresentation(Composite parent, IStackPresentationSite stackSite) {
        super(stackSite);
        this.tabFolder = new CTabFolder(parent, tabPos | 0x800);
        this.tabFolder.MIN_TAB_WIDTH = preferenceStore.getInt("EDITOR_TAB_WIDTH");
        this.tabFolder.setTabList(new Control[0]);
        this.tabFolder.addCTabFolderListener(this.closeListener);
        this.tabFolder.addListener(13, this.selectionListener);
        this.tabFolder.addListener(11, this.resizeListener);
        this.tabFolder.addMouseListener(this.mouseListener);
        this.tabFolder.addListener(35, this.menuListener);
        PresentationUtil.addDragListener((Control)this.tabFolder, (Listener)this.dragListener);
        this.tabFolder.getShell().addShellListener((ShellListener)this.shellListener);
        this.populateSystemMenu((IMenuManager)this.systemMenuManager);
    }

    private void populateSystemMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new GroupMarker("misc"));
        menuManager.add((IContributionItem)new GroupMarker("restore"));
        menuManager.add((IContributionItem)new UpdatingActionContributionItem((ISelfUpdatingAction)new SystemMenuRestore(this.getSite())));
        menuManager.add((IContributionItem)new SystemMenuMove(this.getSite(), this.getPaneName()));
        menuManager.add((IContributionItem)new GroupMarker("size"));
        menuManager.add((IContributionItem)new GroupMarker("state"));
        menuManager.add((IContributionItem)new UpdatingActionContributionItem((ISelfUpdatingAction)new SystemMenuMaximize(this.getSite())));
        menuManager.add((IContributionItem)new Separator("close"));
        menuManager.add((IContributionItem)new UpdatingActionContributionItem((ISelfUpdatingAction)new SystemMenuClose(this.getSite())));
        this.getSite().addSystemActions(menuManager);
    }

    private final int indexOf(IPresentablePart part) {
        if (part == null) {
            return this.tabFolder.getItemCount();
        }
        CTabItem[] items = this.tabFolder.getItems();
        int idx = 0;
        while (idx < items.length) {
            if (part == this.getPartForTab(items[idx])) {
                return idx;
            }
            ++idx;
        }
        return items.length;
    }

    protected final CTabItem getTab(IPresentablePart part) {
        CTabItem[] items = this.tabFolder.getItems();
        int idx = this.indexOf(part);
        return idx < items.length ? items[idx] : null;
    }

    protected void childPropertyChanged(IPresentablePart part, int property) {
        this.initTab(this.getTab(part), part);
    }

    protected final IPresentablePart getPartForTab(CTabItem item) {
        return (IPresentablePart)item.getData(TAB_DATA);
    }

    protected CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed();
    }

    private void setControlSize() {
        if (this.current != null && this.tabFolder != null) {
            this.current.setBounds(R21EditorStackPresentation.calculatePageBounds(this.tabFolder));
        }
    }

    public static Rectangle calculatePageBounds(CTabFolder folder) {
        if (folder == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bounds = folder.getBounds();
        Rectangle offset = folder.getClientArea();
        bounds.x += offset.x;
        bounds.y += offset.y;
        bounds.width = offset.width;
        bounds.height = offset.height;
        return bounds;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.tabFolder.getShell().removeShellListener((ShellListener)this.shellListener);
        this.tabFolder.removeCTabFolderListener(this.closeListener);
        PresentationUtil.removeDragListener((Control)this.tabFolder, (Listener)this.dragListener);
        this.systemMenuManager.dispose();
        this.systemMenuManager.removeAll();
        this.tabFolder.dispose();
        this.tabFolder = null;
    }

    private void updateGradient() {
        int[] bgPercents;
        Color[] bgColors;
        Color fgColor;
        if (this.isDisposed()) {
            return;
        }
        boolean vertical = false;
        if (this.activeState == 1) {
            if (this.getShellActivated()) {
                fgColor = R21Colors.getSystemColor(30);
                bgColors = R21Colors.getActiveEditorGradient();
                bgPercents = R21Colors.getActiveEditorGradientPercents();
            } else {
                fgColor = R21Colors.getSystemColor(33);
                bgColors = R21Colors.getDeactivatedEditorGradient();
                bgPercents = R21Colors.getDeactivatedEditorGradientPercents();
            }
        } else if (this.activeState == 2) {
            fgColor = R21Colors.getSystemColor(24);
            bgColors = R21Colors.getActiveNoFocusEditorGradient();
            bgPercents = R21Colors.getActiveNoFocusEditorGradientPercents();
        } else {
            fgColor = null;
            bgColors = null;
            bgPercents = null;
        }
        this.drawGradient(fgColor, bgColors, bgPercents, vertical);
    }

    protected void drawGradient(Color fgColor, Color[] bgColors, int[] percentages, boolean vertical) {
        this.tabFolder.setSelectionForeground(fgColor);
        this.tabFolder.setSelectionBackground(bgColors, percentages);
        this.tabFolder.update();
    }

    boolean getShellActivated() {
        Window window = this.getWindow();
        if (window instanceof WorkbenchWindow) {
            return ((WorkbenchWindow)window).getShellActivated();
        }
        return false;
    }

    public Window getWindow() {
        Object data;
        Control ctrl = this.getControl();
        if (ctrl != null && (data = ctrl.getShell().getData()) instanceof Window) {
            return (Window)data;
        }
        return null;
    }

    private CTabItem createPartTab(IPresentablePart part, int tabIndex) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0, tabIndex);
        tabItem.setData(TAB_DATA, part);
        part.addPropertyListener(this.childPropertyChangeListener);
        tabItem.addDisposeListener(this.tabDisposeListener);
        this.initTab(tabItem, part);
        return tabItem;
    }

    protected void initTab(CTabItem tabItem, IPresentablePart part) {
        tabItem.setText(this.getLabelText(part, true, false));
        tabItem.setToolTipText(this.getLabelToolTipText(part));
        tabItem.setImage(this.getLabelImage(part));
    }

    String getLabelText(IPresentablePart presentablePart, boolean dirtyLeft, boolean includePath) {
        String title;
        String text = title = presentablePart.getName().trim();
        if (includePath) {
            String titleTooltip = presentablePart.getTitleToolTip().trim();
            if (titleTooltip.endsWith(title)) {
                titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf(title)).trim();
            }
            if (titleTooltip.endsWith("\\")) {
                titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf("\\")).trim();
            }
            if (titleTooltip.endsWith("/")) {
                titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf("/")).trim();
            }
            if (titleTooltip.length() >= 1) {
                text = String.valueOf(text) + " - " + titleTooltip;
            }
        }
        if (presentablePart.isDirty()) {
            text = dirtyLeft ? "* " + text : String.valueOf(text) + " *";
        }
        return text;
    }

    Image getLabelImage(IPresentablePart presentablePart) {
        return presentablePart.getTitleImage();
    }

    String getLabelToolTipText(IPresentablePart presentablePart) {
        return presentablePart.getTitleToolTip();
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        int idx = cookie instanceof Integer ? ((Integer)cookie).intValue() : this.tabFolder.getItemCount();
        this.addPart(newPart, idx);
    }

    public void addPart(IPresentablePart newPart, int index) {
        if (this.getTab(newPart) != null) {
            return;
        }
        this.createPartTab(newPart, index);
    }

    public void removePart(IPresentablePart oldPart) {
        CTabItem item;
        if (this.current == oldPart) {
            this.current = null;
        }
        if ((item = this.getTab(oldPart)) == null) {
            return;
        }
        oldPart.setVisible(false);
        item.dispose();
    }

    public void selectPart(IPresentablePart toSelect) {
        if (toSelect == this.current) {
            return;
        }
        IPresentablePart oldPart = this.current;
        this.current = toSelect;
        if (this.current != null) {
            this.tabFolder.setSelection(this.indexOf(this.current));
            this.current.setVisible(true);
            this.setControlSize();
        }
        if (oldPart != null) {
            oldPart.setVisible(false);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.tabFolder.setBounds(bounds);
        this.setControlSize();
    }

    public Point computeMinimumSize() {
        return Geometry.getSize((Rectangle)this.tabFolder.computeTrim(0, 0, 0, 0));
    }

    public void setVisible(boolean isVisible) {
        if (this.current != null) {
            this.current.setVisible(isVisible);
        }
        this.getTabFolder().setVisible(isVisible);
    }

    public void setState(int state) {
    }

    public IMenuManager getSystemMenuManager() {
        return this.systemMenuManager;
    }

    protected void showSystemMenu(Point point) {
        Menu aMenu = this.systemMenuManager.createContextMenu((Control)this.tabFolder.getParent());
        this.systemMenuManager.update(true);
        aMenu.setLocation(point.x, point.y);
        aMenu.setVisible(true);
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        Point localPos = this.tabFolder.toControl(location);
        CTabItem tabUnderPointer = this.tabFolder.getItem(localPos);
        if (tabUnderPointer == null) {
            return null;
        }
        int dragOverIndex = this.tabFolder.indexOf(tabUnderPointer);
        return new StackDropResult(Geometry.toDisplay((Control)this.tabFolder, (Rectangle)tabUnderPointer.getBounds()), (Object)new Integer(dragOverIndex));
    }

    public void showSystemMenu() {
        if (this.current != null) {
            CTabItem item = this.getTab(this.current);
            this.getSite().selectPart(this.getCurrentPart());
            Rectangle bounds = item.getBounds();
            int y = bounds.height;
            if (this.getTabFolder().getTabPosition() == 1024) {
                y += bounds.y;
            }
            this.showSystemMenu(this.getTabFolder().toDisplay(bounds.x, y));
        }
    }

    public void showPaneMenu() {
        CTabItem tab;
        IPartMenu menu = this.getPartMenu();
        if (menu != null && (tab = this.getTab(this.getCurrentPart())) != null && tab.getControl() != null) {
            Rectangle bounds = DragUtil.getDisplayBounds((Control)tab.getControl());
            menu.showMenu(new Point(bounds.x, bounds.y + bounds.height));
        }
    }

    protected IPartMenu getPartMenu() {
        IPresentablePart part = this.getCurrentPart();
        if (part == null) {
            return null;
        }
        return part.getMenu();
    }

    public Control[] getTabList(IPresentablePart part) {
        ArrayList<Control> list = new ArrayList<Control>();
        if (this.getControl() != null) {
            list.add(this.getControl());
        }
        if (part.getToolBar() != null) {
            list.add(part.getToolBar());
        }
        if (part.getControl() != null) {
            list.add(part.getControl());
        }
        return list.toArray(new Control[list.size()]);
    }

    public IPresentablePart getCurrentPart() {
        return this.current;
    }

    protected String getPaneName() {
        return R21PresentationMessages.getString("EditorPane.moveEditor");
    }

    public void setActive(int newState) {
        this.activeState = newState;
        this.updateGradient();
    }

    public void restoreState(IPresentationSerializer serializer, IMemento savedState) {
        IMemento[] parts = savedState.getChildren("part");
        int idx = 0;
        while (idx < parts.length) {
            IPresentablePart part;
            String id = parts[idx].getString("id");
            if (id != null && (part = serializer.getPart(id)) != null) {
                this.addPart(part, this.tabFolder.getItemCount());
            }
            ++idx;
        }
    }

    public void saveState(IPresentationSerializer context, IMemento memento) {
        super.saveState(context, memento);
        List parts = this.getPresentableParts();
        for (IPresentablePart next : parts) {
            IMemento childMem = memento.createChild("part");
            childMem.putString("id", context.getId(next));
        }
    }

    private List getPresentableParts() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        CTabItem[] items = this.tabFolder.getItems();
        ArrayList<IPresentablePart> result = new ArrayList<IPresentablePart>(items.length);
        int idx = 0;
        while (idx < this.tabFolder.getItemCount()) {
            result.add(this.getPartForTab(items[idx]));
            ++idx;
        }
        return result;
    }
}

