/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.fix.LinkedFix;
import org.eclipse.jdt.internal.corext.fix.PositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsUpdate;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class Java50Fix
extends LinkedFix {
    private static final String OVERRIDE = "Override";
    private static final String DEPRECATED = "Deprecated";

    public static Java50Fix createAddOverrideAnnotationFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() != 67109491) {
            return null;
        }
        return Java50Fix.createFix(compilationUnit, problem, OVERRIDE, FixMessages.Java50Fix_AddOverride_description);
    }

    public static Java50Fix createAddDeprectatedAnnotation(CompilationUnit compilationUnit, IProblemLocation problem) {
        int id = problem.getProblemId();
        if (id != 536871540 && id != 536871541 && id != 536871542) {
            return null;
        }
        return Java50Fix.createFix(compilationUnit, problem, DEPRECATED, FixMessages.Java50Fix_AddDeprecated_description);
    }

    private static Java50Fix createFix(CompilationUnit compilationUnit, IProblemLocation problem, String annotation, String label) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
            return null;
        }
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode == null) {
            return null;
        }
        ASTNode declaringNode = Java50Fix.getDeclaringNode(selectedNode);
        if (!(declaringNode instanceof BodyDeclaration)) {
            return null;
        }
        BodyDeclaration declaration = (BodyDeclaration)declaringNode;
        AnnotationRewriteOperation operation = new AnnotationRewriteOperation(declaration, annotation);
        return new Java50Fix(label, compilationUnit, new IFixRewriteOperation[]{operation});
    }

    public static Java50Fix createRawTypeReferenceFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        ArrayList operations = new ArrayList();
        SimpleType node = Java50Fix.createRawTypeReferenceOperations(compilationUnit, new IProblemLocation[]{problem}, operations);
        if (operations.size() == 0) {
            return null;
        }
        return new Java50Fix(Messages.format(FixMessages.Java50Fix_AddTypeParameters_description, node.getName()), compilationUnit, operations.toArray(new IFixRewriteOperation[operations.size()]));
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean addOverrideAnnotation, boolean addDeprecatedAnnotation, boolean rawTypeReference) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
            return null;
        }
        if (!(addOverrideAnnotation || addDeprecatedAnnotation || rawTypeReference)) {
            return null;
        }
        ArrayList operations = new ArrayList();
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        if (addOverrideAnnotation) {
            Java50Fix.createAddOverrideAnnotationOperations(compilationUnit, locations, operations);
        }
        if (addDeprecatedAnnotation) {
            Java50Fix.createAddDeprecatedAnnotationOperations(compilationUnit, locations, operations);
        }
        if (rawTypeReference) {
            Java50Fix.createRawTypeReferenceOperations(compilationUnit, locations, operations);
        }
        if (operations.size() == 0) {
            return null;
        }
        IFixRewriteOperation[] operationsArray = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new Java50Fix("", compilationUnit, operationsArray);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addOverrideAnnotation, boolean addDeprecatedAnnotation, boolean rawTypeReferences) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
            return null;
        }
        if (!(addOverrideAnnotation || addDeprecatedAnnotation || rawTypeReferences)) {
            return null;
        }
        ArrayList operations = new ArrayList();
        if (addOverrideAnnotation) {
            Java50Fix.createAddOverrideAnnotationOperations(compilationUnit, problems, operations);
        }
        if (addDeprecatedAnnotation) {
            Java50Fix.createAddDeprecatedAnnotationOperations(compilationUnit, problems, operations);
        }
        if (rawTypeReferences) {
            Java50Fix.createRawTypeReferenceOperations(compilationUnit, problems, operations);
        }
        if (operations.size() == 0) {
            return null;
        }
        IFixRewriteOperation[] operationsArray = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new Java50Fix("", compilationUnit, operationsArray);
    }

    private static void createAddDeprecatedAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List result) {
        int i = 0;
        while (i < locations.length) {
            ASTNode declaringNode;
            IProblemLocation problem;
            ASTNode selectedNode;
            int id = locations[i].getProblemId();
            if ((id == 536871540 || id == 536871541 || id == 536871542) && (selectedNode = (problem = locations[i]).getCoveringNode(compilationUnit)) != null && (declaringNode = Java50Fix.getDeclaringNode(selectedNode)) instanceof BodyDeclaration) {
                BodyDeclaration declaration = (BodyDeclaration)declaringNode;
                AnnotationRewriteOperation operation = new AnnotationRewriteOperation(declaration, DEPRECATED);
                result.add(operation);
            }
            ++i;
        }
    }

    private static void createAddOverrideAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List result) {
        int i = 0;
        while (i < locations.length) {
            ASTNode declaringNode;
            IProblemLocation problem;
            ASTNode selectedNode;
            if (locations[i].getProblemId() == 67109491 && (selectedNode = (problem = locations[i]).getCoveringNode(compilationUnit)) != null && (declaringNode = Java50Fix.getDeclaringNode(selectedNode)) instanceof BodyDeclaration) {
                BodyDeclaration declaration = (BodyDeclaration)declaringNode;
                AnnotationRewriteOperation operation = new AnnotationRewriteOperation(declaration, OVERRIDE);
                result.add(operation);
            }
            ++i;
        }
    }

    private static SimpleType createRawTypeReferenceOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List operations) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            int id = problem.getProblemId();
            if (id == 16777748 || id == 16777788 || id == 16777747) {
                MethodInvocation invocation;
                ASTNode rawReference;
                ASTNode rawReference2;
                ASTNode node = problem.getCoveredNode(compilationUnit);
                if (node instanceof ClassInstanceCreation) {
                    rawReference2 = (ASTNode)node.getStructuralProperty((StructuralPropertyDescriptor)ClassInstanceCreation.TYPE_PROPERTY);
                    if (Java50Fix.isRawTypeReference(rawReference2)) {
                        result.add(rawReference2);
                    }
                } else if (node instanceof SimpleName) {
                    rawReference2 = node.getParent();
                    if (Java50Fix.isRawTypeReference(rawReference2)) {
                        result.add(rawReference2);
                    }
                } else if (node instanceof MethodInvocation && (rawReference = Java50Fix.getRawReference(invocation = (MethodInvocation)node, compilationUnit)) != null) {
                    result.add(rawReference);
                }
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        SimpleType[] types = result.toArray(new SimpleType[result.size()]);
        operations.add(new AddTypeParametersOperation(types));
        return types[0];
    }

    private static ASTNode getRawReference(MethodInvocation invocation, CompilationUnit compilationUnit) {
        ASTNode rawReference;
        ASTNode rawReference2;
        Name name1 = (Name)invocation.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.NAME_PROPERTY);
        if (name1 instanceof SimpleName && (rawReference2 = Java50Fix.getRawReference((SimpleName)name1, compilationUnit)) != null) {
            return rawReference2;
        }
        Expression expr = (Expression)invocation.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY);
        if (expr instanceof SimpleName) {
            ASTNode rawReference3 = Java50Fix.getRawReference((SimpleName)expr, compilationUnit);
            if (rawReference3 != null) {
                return rawReference3;
            }
        } else if (expr instanceof QualifiedName) {
            ASTNode rawReference4;
            Name name = (Name)expr;
            while (name instanceof QualifiedName) {
                SimpleName simpleName = (SimpleName)name.getStructuralProperty((StructuralPropertyDescriptor)QualifiedName.NAME_PROPERTY);
                ASTNode rawReference5 = Java50Fix.getRawReference(simpleName, compilationUnit);
                if (rawReference5 != null) {
                    return rawReference5;
                }
                name = (Name)name.getStructuralProperty((StructuralPropertyDescriptor)QualifiedName.QUALIFIER_PROPERTY);
            }
            if (name instanceof SimpleName && (rawReference4 = Java50Fix.getRawReference((SimpleName)name, compilationUnit)) != null) {
                return rawReference4;
            }
        } else if (expr instanceof MethodInvocation && (rawReference = Java50Fix.getRawReference((MethodInvocation)expr, compilationUnit)) != null) {
            return rawReference;
        }
        return null;
    }

    private static ASTNode getRawReference(SimpleName name, CompilationUnit compilationUnit) {
        SimpleName[] names = LinkedNodeFinder.findByNode((ASTNode)compilationUnit, name);
        int j = 0;
        while (j < names.length) {
            MethodDeclaration methodDecl;
            SingleVariableDeclaration declaration;
            ASTNode result;
            if (names[j].getParent() instanceof VariableDeclarationFragment) {
                FieldDeclaration declaration2;
                VariableDeclarationStatement statement;
                ASTNode result2;
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)names[j].getParent();
                if (fragment.getParent() instanceof VariableDeclarationStatement ? Java50Fix.isRawTypeReference(result2 = (ASTNode)(statement = (VariableDeclarationStatement)fragment.getParent()).getStructuralProperty((StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY)) : fragment.getParent() instanceof FieldDeclaration && Java50Fix.isRawTypeReference(result2 = (ASTNode)(declaration2 = (FieldDeclaration)fragment.getParent()).getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY))) {
                    return result2;
                }
            } else if (names[j].getParent() instanceof SingleVariableDeclaration ? Java50Fix.isRawTypeReference(result = (ASTNode)(declaration = (SingleVariableDeclaration)names[j].getParent()).getStructuralProperty((StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY)) : names[j].getParent() instanceof MethodDeclaration && Java50Fix.isRawTypeReference(result = (ASTNode)(methodDecl = (MethodDeclaration)names[j].getParent()).getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY))) {
                return result;
            }
            ++j;
        }
        return null;
    }

    private static boolean isRawTypeReference(ASTNode node) {
        if (!(node instanceof SimpleType)) {
            return false;
        }
        ITypeBinding binding = ((SimpleType)node).resolveBinding().getTypeDeclaration();
        ITypeBinding[] parameters = binding.getTypeParameters();
        return parameters.length != 0;
    }

    private static ASTNode getDeclaringNode(ASTNode selectedNode) {
        ASTNode declaringNode = null;
        if (selectedNode instanceof MethodDeclaration) {
            declaringNode = selectedNode;
        } else if (selectedNode instanceof SimpleName) {
            StructuralPropertyDescriptor locationInParent = selectedNode.getLocationInParent();
            if (locationInParent == MethodDeclaration.NAME_PROPERTY || locationInParent == TypeDeclaration.NAME_PROPERTY) {
                declaringNode = selectedNode.getParent();
            } else if (locationInParent == VariableDeclarationFragment.NAME_PROPERTY) {
                declaringNode = selectedNode.getParent().getParent();
            }
        }
        return declaringNode;
    }

    private Java50Fix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewrites) {
        super(name, compilationUnit, fixRewrites);
    }

    private static class AnnotationRewriteOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final BodyDeclaration fBodyDeclaration;
        private final String fAnnotation;

        public AnnotationRewriteOperation(BodyDeclaration bodyDeclaration, String annotation) {
            this.fBodyDeclaration = bodyDeclaration;
            this.fAnnotation = annotation;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            AST ast = cuRewrite.getRoot().getAST();
            ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite((ASTNode)this.fBodyDeclaration, this.fBodyDeclaration.getModifiersProperty());
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            newAnnotation.setTypeName((Name)ast.newSimpleName(this.fAnnotation));
            TextEditGroup group = this.createTextEditGroup(Messages.format(FixMessages.Java50Fix_AddMissingAnnotation_description, this.fAnnotation));
            textEditGroups.add(group);
            listRewrite.insertFirst((ASTNode)newAnnotation, group);
        }
    }

    private static class AddTypeParametersOperation
    extends LinkedFix.AbstractLinkedFixRewriteOperation {
        private final SimpleType[] fTypes;

        public AddTypeParametersOperation(SimpleType[] types) {
            this.fTypes = types;
        }

        public ITrackedNodePosition rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups, List positionGroups) throws CoreException {
            InferTypeArgumentsTCModel model = new InferTypeArgumentsTCModel();
            InferTypeArgumentsConstraintCreator creator = new InferTypeArgumentsConstraintCreator(model, true);
            CompilationUnit root = cuRewrite.getRoot();
            root.accept((ASTVisitor)creator);
            InferTypeArgumentsConstraintsSolver solver = new InferTypeArgumentsConstraintsSolver(model);
            InferTypeArgumentsUpdate update = solver.solveConstraints((IProgressMonitor)new NullProgressMonitor());
            solver = null;
            ParameterizedType[] nodes = InferTypeArgumentsRefactoring.inferArguments(this.fTypes, update, model, cuRewrite);
            if (nodes.length == 0) {
                return null;
            }
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] instanceof ParameterizedType) {
                    ParameterizedType type = nodes[0];
                    List args = (List)type.getStructuralProperty((StructuralPropertyDescriptor)ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
                    int j = 0;
                    Iterator iter = args.iterator();
                    while (iter.hasNext()) {
                        PositionGroup group = new PositionGroup("G" + i + "_" + j);
                        Type argType = (Type)iter.next();
                        if (positionGroups.isEmpty()) {
                            group.addFirstPosition(astRewrite.track((ASTNode)argType));
                        } else {
                            group.addPosition(astRewrite.track((ASTNode)argType));
                        }
                        if (argType.isWildcardType()) {
                            group.addProposal("?", "?");
                            group.addProposal("Object", "Object");
                        }
                        positionGroups.add(group);
                        ++j;
                    }
                }
                ++i;
            }
            return astRewrite.track((ASTNode)nodes[0]);
        }
    }
}

