/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class CVSMergeSubscriber
extends CVSSyncTreeSubscriber
implements IResourceChangeListener,
ISubscriberChangeListener {
    public static final String ID = "org.eclipse.team.cvs.ui.cvsmerge-participant";
    public static final String ID_MODAL = "org.eclipse.team.cvs.ui.cvsmerge-participant-modal";
    private static final String UNIQUE_ID_PREFIX = "merge-";
    private CVSTag start;
    private CVSTag end;
    private List roots;
    private CVSResourceVariantTree remoteTree;
    private MergeBaseTree baseTree;

    public CVSMergeSubscriber(IResource[] roots, CVSTag start, CVSTag end) {
        this(CVSMergeSubscriber.getUniqueId(), roots, start, end);
    }

    private static QualifiedName getUniqueId() {
        String uniqueId = Long.toString(System.currentTimeMillis());
        return new QualifiedName(ID, "CVSmerge-" + uniqueId);
    }

    public CVSMergeSubscriber(QualifiedName id, IResource[] roots, CVSTag start, CVSTag end) {
        super(id, NLS.bind((String)CVSMessages.CVSMergeSubscriber_2, (Object[])new String[]{start.getName(), end.getName()}));
        this.start = start;
        this.end = end;
        this.roots = new ArrayList(Arrays.asList(roots));
        this.initialize();
    }

    private void initialize() {
        QualifiedName id = this.getId();
        String syncKeyPrefix = id.getLocalName();
        PersistantResourceVariantByteStore remoteSynchronizer = new PersistantResourceVariantByteStore(new QualifiedName("org.eclipse.team.cvs", String.valueOf(syncKeyPrefix) + this.end.getName()));
        this.remoteTree = new CVSResourceVariantTree((ResourceVariantByteStore)remoteSynchronizer, this.getEndTag(), this.getCacheFileContentsHint()){

            public IResource[] refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
                monitor.beginTask(null, 100);
                try {
                    IResource[] refreshed = super.refresh(resources, depth, monitor);
                    CVSMergeSubscriber.this.compareWithRemote(refreshed, Policy.subMonitorFor(monitor, 50));
                    IResource[] iResourceArray = refreshed;
                    return iResourceArray;
                }
                finally {
                    monitor.done();
                }
            }
        };
        PersistantResourceVariantByteStore baseSynchronizer = new PersistantResourceVariantByteStore(new QualifiedName("org.eclipse.team.cvs", String.valueOf(syncKeyPrefix) + this.start.getName()));
        this.baseTree = new MergeBaseTree((ResourceVariantByteStore)baseSynchronizer, this.getStartTag(), this.getCacheFileContentsHint(), syncKeyPrefix);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().addListener(this);
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        CVSMergeSyncInfo info = new CVSMergeSyncInfo(local, base, remote, (Subscriber)this);
        info.init();
        return info;
    }

    public void merged(IResource[] resources) throws TeamException {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.internalMerged(resource);
            ++i;
        }
        this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])resources));
    }

    private void internalMerged(IResource resource) throws TeamException {
        byte[] remoteBytes = this.getRemoteByteStore().getBytes(resource);
        this.baseTree.merged(resource, remoteBytes);
    }

    public void cancel() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.remoteTree.dispose();
        this.baseTree.dispose();
    }

    public IResource[] roots() {
        return this.roots.toArray(new IResource[this.roots.size()]);
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return this.getBaseTree().hasResourceVariant(resource) || this.getRemoteTree().hasResourceVariant(resource);
    }

    public CVSTag getStartTag() {
        return this.start;
    }

    public CVSTag getEndTag() {
        return this.end;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 4) {
                            IProject project = (IProject)resource;
                            if (!project.isAccessible()) {
                                return false;
                            }
                            if ((delta.getFlags() & 0x4000) != 0) {
                                return false;
                            }
                            if (RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId()) == null) {
                                return false;
                            }
                        }
                        if (CVSMergeSubscriber.this.roots.contains(resource)) {
                            if (delta.getKind() == 2 || delta.getKind() == 8192) {
                                CVSMergeSubscriber.this.cancel();
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e.getStatus());
        }
    }

    public boolean isMerged(IResource resource) throws TeamException {
        byte[] remoteBytes = this.getRemoteByteStore().getBytes(resource);
        return this.baseTree.isMerged(resource, remoteBytes);
    }

    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            ISubscriberChangeEvent delta = deltas[i];
            switch (delta.getFlags()) {
                case 4: {
                    IResource resource = delta.getResource();
                    if (!this.roots.remove(resource)) break;
                    this.fireTeamResourceChange(new ISubscriberChangeEvent[]{delta});
                }
            }
            ++i;
        }
    }

    protected IResourceVariantTree getBaseTree() {
        return this.baseTree;
    }

    protected IResourceVariantTree getRemoteTree() {
        return this.remoteTree;
    }

    protected boolean getCacheFileContentsHint() {
        return true;
    }

    private void compareWithRemote(IResource[] refreshed, IProgressMonitor monitor) throws CVSException, TeamException {
        if (refreshed.length == 0) {
            return;
        }
        SyncInfoFilter.ContentComparisonSyncInfoFilter contentFilter = new SyncInfoFilter.ContentComparisonSyncInfoFilter();
        monitor.beginTask(null, refreshed.length * 100);
        int i = 0;
        while (i < refreshed.length) {
            IResource resource = refreshed[i];
            if (resource.getType() == 1) {
                ICVSFile local = CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
                byte[] localBytes = local.getSyncBytes();
                byte[] remoteBytes = this.getRemoteByteStore().getBytes(resource);
                if (remoteBytes != null && localBytes != null && local.exists() && !ResourceSyncInfo.getRevision(remoteBytes).equals(ResourceSyncInfo.getRevision(localBytes)) && contentFilter.select(this.getSyncInfo(resource), Policy.subMonitorFor(monitor, 100))) {
                    this.internalMerged(resource);
                }
            }
            ++i;
        }
        monitor.done();
    }

    private PersistantResourceVariantByteStore getRemoteByteStore() {
        return (PersistantResourceVariantByteStore)((CVSResourceVariantTree)this.getRemoteTree()).getByteStore();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CVSMergeSubscriber)) {
            return false;
        }
        CVSMergeSubscriber s = (CVSMergeSubscriber)((Object)other);
        return this.getEndTag().equals(s.getEndTag()) && this.getStartTag().equals(s.getStartTag()) && this.rootsEqual((Subscriber)s);
    }

    private final class MergeBaseTree
    extends CVSResourceVariantTree {
        private PersistantResourceVariantByteStore mergedSynchronizer;

        private MergeBaseTree(ResourceVariantByteStore cache, CVSTag tag, boolean cacheFileContentsHint, String syncKeyPrefix) {
            super(cache, tag, cacheFileContentsHint);
            this.mergedSynchronizer = new PersistantResourceVariantByteStore(new QualifiedName("org.eclipse.team.cvs", String.valueOf(syncKeyPrefix) + "0merged"));
        }

        public IResource[] refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
            ArrayList<IResource> unrefreshed = new ArrayList<IResource>();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!this.hasResourceVariant(resource)) {
                    unrefreshed.add(resource);
                }
                ++i;
            }
            if (unrefreshed.isEmpty()) {
                monitor.done();
                return new IResource[0];
            }
            IResource[] refreshed = super.refresh(unrefreshed.toArray(new IResource[unrefreshed.size()]), depth, monitor);
            return refreshed;
        }

        public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
            byte[] parentBytes;
            byte[] mergedBytes = this.mergedSynchronizer.getBytes(resource);
            if (mergedBytes != null && (parentBytes = this.getByteStore().getBytes((IResource)resource.getParent())) != null) {
                return RemoteFile.fromBytes(resource, mergedBytes, parentBytes);
            }
            return super.getResourceVariant(resource);
        }

        public void merged(IResource resource, byte[] remoteBytes) throws TeamException {
            if (remoteBytes == null) {
                this.getByteStore().deleteBytes(resource);
            } else {
                this.getByteStore().setBytes(resource, remoteBytes);
            }
        }

        public boolean isMerged(IResource resource, byte[] remoteBytes) throws TeamException {
            byte[] mergedBytes = this.getByteStore().getBytes(resource);
            return Util.equals(mergedBytes, remoteBytes);
        }

        public void dispose() {
            this.mergedSynchronizer.dispose();
            super.dispose();
        }
    }
}

