/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.ui.PlatformUI;

public class DateTagDialog
extends TrayDialog {
    DateArea dateArea;
    TimeArea timeArea;
    IDialogSettings settings;
    private Date dateEntered;

    public DateTagDialog(Shell parentShell) {
        super(parentShell);
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("DateTagDialog");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("DateTagDialog");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CVSUIMessages.DateTagDialog_5);
    }

    protected Control createDialogArea(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.initializeDialogUnits((Control)topLevel);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        topLevel.setLayout((Layout)layout);
        this.createDateArea(topLevel);
        this.createTimeArea(topLevel);
        this.initializeValues();
        this.updateWidgetEnablements();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.team.cvs.ui.date_tag_dialog_context");
        Dialog.applyDialogFont((Control)parent);
        return topLevel;
    }

    private void createDateArea(Composite topLevel) {
        this.dateArea = new DateArea();
        this.dateArea.createArea(topLevel);
    }

    private void createTimeArea(Composite topLevel) {
        this.timeArea = new TimeArea();
        this.timeArea.createArea(topLevel);
    }

    private void initializeValues() {
        Calendar calendar = Calendar.getInstance();
        this.dateArea.initializeValues(calendar);
        this.timeArea.initializeValues(calendar);
    }

    private void updateWidgetEnablements() {
        this.timeArea.updateWidgetEnablements();
        this.dateArea.updateWidgetEnablements();
    }

    public Date getDate() {
        return this.dateEntered;
    }

    private Date privateGetDate() {
        Calendar calendar = Calendar.getInstance();
        this.dateArea.adjustCalendar(calendar);
        this.timeArea.adjustCalendar(calendar);
        return calendar.getTime();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.dateEntered = this.privateGetDate();
        }
        super.buttonPressed(buttonId);
    }

    public class DateArea
    extends DialogArea {
        private Combo fromDayCombo;
        private Combo fromMonthCombo;
        private Combo fromYearCombo;

        public void createArea(Composite parent) {
            Composite composite = this.createComposite(parent, 4, false);
            this.initializeDialogUnits((Control)composite);
            this.createLabel(composite, CVSUIMessages.DateTagDialog_0, 1);
            this.fromMonthCombo = new Combo(composite, 8);
            this.fromDayCombo = new Combo(composite, 8);
            this.fromDayCombo.setTextLimit(2);
            this.fromYearCombo = new Combo(composite, 0);
            this.fromYearCombo.setTextLimit(4);
            String[] days = new String[31];
            int i = 0;
            while (i < 31) {
                days[i] = String.valueOf(i + 1);
                ++i;
            }
            String[] months = new String[12];
            SimpleDateFormat format = new SimpleDateFormat("MMMM");
            Calendar calendar = Calendar.getInstance();
            int i2 = 0;
            while (i2 < 12) {
                calendar.set(2, i2);
                months[i2] = format.format(calendar.getTime());
                ++i2;
            }
            String[] years = new String[5];
            Calendar calender = Calendar.getInstance();
            int i3 = 0;
            while (i3 < 5) {
                years[i3] = String.valueOf(calender.get(1) - i3);
                ++i3;
            }
            this.fromDayCombo.setItems(days);
            this.fromMonthCombo.setItems(months);
            this.fromYearCombo.setItems(years);
        }

        public void initializeValues(Calendar calendar) {
            this.fromDayCombo.select(calendar.get(5) - 1);
            this.fromMonthCombo.select(calendar.get(2));
            String yearValue = String.valueOf(calendar.get(1));
            int index = this.fromYearCombo.indexOf(yearValue);
            if (index == -1) {
                this.fromYearCombo.add(yearValue);
                index = this.fromYearCombo.indexOf(yearValue);
            }
            this.fromYearCombo.select(index);
            DateTagDialog.this.timeArea.initializeValues(calendar);
        }

        public void updateWidgetEnablements() {
        }

        public void adjustCalendar(Calendar calendar) {
            calendar.set(Integer.parseInt(String.valueOf(this.fromYearCombo.getText())), this.fromMonthCombo.getSelectionIndex(), Integer.parseInt(String.valueOf(this.fromDayCombo.getText())), 0, 0, 0);
        }
    }

    public class TimeArea
    extends DialogArea {
        private Combo hourCombo;
        private Combo minuteCombo;
        private Combo secondCombo;
        private Button includeTime;
        private Button localTime;
        private Button utcTime;

        public void createArea(Composite parent) {
            Composite composite = this.createComposite(parent, 2, false);
            this.initializeDialogUnits((Control)composite);
            this.includeTime = this.createCheckbox(composite, CVSUIMessages.DateTagDialog_1, 2);
            this.createLabel(composite, CVSUIMessages.DateTagDialog_2, 1);
            Composite dateComposite = new Composite(composite, 0);
            GridLayout dateLayout = new GridLayout();
            dateLayout.numColumns = 3;
            dateComposite.setLayout((Layout)dateLayout);
            this.hourCombo = new Combo(dateComposite, 8);
            this.hourCombo.setTextLimit(2);
            this.minuteCombo = new Combo(dateComposite, 8);
            this.minuteCombo.setTextLimit(2);
            this.secondCombo = new Combo(dateComposite, 8);
            this.secondCombo.setTextLimit(2);
            this.localTime = this.createRadioButton(composite, CVSUIMessages.DateTagDialog_3, 2);
            this.utcTime = this.createRadioButton(composite, CVSUIMessages.DateTagDialog_4, 2);
            String[] sixty = new String[60];
            int i = 0;
            while (i < 60) {
                sixty[i] = String.valueOf(i);
                ++i;
            }
            String[] hours = new String[24];
            int i2 = 0;
            while (i2 < 24) {
                hours[i2] = String.valueOf(i2);
                ++i2;
            }
            this.hourCombo.setItems(hours);
            this.minuteCombo.setItems(sixty);
            this.secondCombo.setItems(sixty);
            this.includeTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TimeArea.this.updateWidgetEnablements();
                }
            });
        }

        public void initializeValues(Calendar calendar) {
            this.hourCombo.select(calendar.get(11));
            this.minuteCombo.select(calendar.get(12));
            this.secondCombo.select(calendar.get(13));
            this.includeTime.setSelection(DateTagDialog.this.settings.getBoolean("includeTime"));
            this.localTime.setSelection(!DateTagDialog.this.settings.getBoolean("utcTime"));
            this.utcTime.setSelection(DateTagDialog.this.settings.getBoolean("utcTime"));
        }

        public void updateWidgetEnablements() {
            this.hourCombo.setEnabled(this.includeTime.getSelection());
            this.minuteCombo.setEnabled(this.includeTime.getSelection());
            this.secondCombo.setEnabled(this.includeTime.getSelection());
            this.localTime.setEnabled(this.includeTime.getSelection());
            this.utcTime.setEnabled(this.includeTime.getSelection());
        }

        public void adjustCalendar(Calendar calendar) {
            if (this.includeTime.getSelection()) {
                calendar.set(11, this.hourCombo.getSelectionIndex());
                calendar.set(12, this.minuteCombo.getSelectionIndex());
                calendar.set(13, this.secondCombo.getSelectionIndex());
                if (this.utcTime.getSelection()) {
                    calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                }
            }
        }
    }
}

