/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.registry;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.ws.internal.model.v10.registry.Registry;
import org.eclipse.wst.ws.internal.model.v10.rtindex.DocumentRoot;
import org.eclipse.wst.ws.internal.model.v10.rtindex.Index;
import org.eclipse.wst.ws.internal.model.v10.rtindex.RTIndexFactory;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.eclipse.wst.ws.internal.registry.GenericResourceFactory;
import org.eclipse.wst.ws.internal.registry.IRegistryManager;
import org.eclipse.wst.ws.internal.registry.ITaxonomyFinder;
import org.eclipse.wst.ws.internal.registry.RegistryService;

public class RegistryManager
implements IRegistryManager {
    private static String REGISTRY = "Registry";
    private static String TAXONOMY = "Taxonomy";
    private static String XML = "xml";
    private Hashtable taxonomyFinders_;
    private Index index_;
    private GenericResourceFactory resourceFactory_ = new GenericResourceFactory();
    private URL registryURL_ = null;
    private String registryPathname_ = null;

    RegistryManager(URL url) {
        this.registryURL_ = url;
        this.taxonomyFinders_ = new Hashtable();
    }

    RegistryManager(String pathname) {
        this.registryPathname_ = pathname;
        this.taxonomyFinders_ = new Hashtable();
    }

    public URL getURL() throws MalformedURLException {
        if (this.registryURL_ == null) {
            this.registryURL_ = new File(this.registryPathname_).toURL();
        }
        return this.registryURL_;
    }

    private URL getURL(String id) throws MalformedURLException {
        String baseUrl = "";
        URL indexUrl = this.getURL();
        String indexString = indexUrl.toString();
        int index = indexString.lastIndexOf("/");
        baseUrl = indexString.substring(0, index + 1);
        String urlString = String.valueOf(baseUrl) + id + "." + XML;
        return new URL(urlString);
    }

    public void refreshManager() {
        this.index_ = null;
    }

    private Index getIndex() throws CoreException {
        if (this.index_ == null) {
            try {
                URL indexURL = this.getURL();
                if (RegistryService.exists(indexURL)) {
                    Resource resource = this.resourceFactory_.createResource(URI.createURI((String)"*.xml"));
                    resource.load(RegistryService.getInputStreamFor(indexURL), null);
                    DocumentRoot document = (DocumentRoot)resource.getContents().get(0);
                    this.index_ = document.getIndex();
                } else {
                    this.index_ = RTIndexFactory.eINSTANCE.createIndex();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)e));
            }
        }
        return this.index_;
    }

    private void saveIndex() throws CoreException {
        DocumentRoot document = RTIndexFactory.eINSTANCE.createDocumentRoot();
        document.setIndex(this.getIndex());
        Resource resource = this.resourceFactory_.createResource(URI.createURI((String)"*.xml"));
        resource.getContents().add((Object)document);
        try {
            resource.save(RegistryService.getOutputStreamFor(this.getURL()), null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)e));
        }
    }

    public void addTaxonomyFinder(String className, ITaxonomyFinder taxonomyFinder) {
        this.taxonomyFinders_.put(className, taxonomyFinder);
    }

    private void addRegistryToIndex(Registry registry) throws CoreException {
        String id = registry.getId();
        if (id == null) {
            id = registry.getRef();
        }
        if (id != null && this.getRegistry(id) == null) {
            this.getIndex().getRegistry().add((Object)registry);
        }
    }

    private void addTaxonomyToIndex(Taxonomy taxonomy) throws CoreException {
        String id = taxonomy.getId();
        if (id == null) {
            id = taxonomy.getRef();
        }
        if (id != null && this.getTaxonomy(id) == null) {
            this.getIndex().getTaxonomy().add((Object)taxonomy);
        }
    }

    public Registry saveRegistry(Registry registry) throws CoreException {
        RegistryService registryService = RegistryService.instance();
        Registry registryRef = null;
        try {
            URL url = this.getURL(String.valueOf(REGISTRY) + registry.getId());
            registryService.saveRegistry(url, registry);
            registryRef = registryService.newRegistryReference(registry);
            registryRef.setLocation(url.toString());
            this.addRegistryToIndex(registryRef);
            this.saveIndex();
        }
        catch (MalformedURLException me) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)me));
        }
        return registryService.newRegistryReference(registryRef);
    }

    public Registry loadRegistry(String uri) throws CoreException {
        String urlString;
        RegistryService registryService;
        block6: {
            Registry registry;
            block5: {
                registryService = RegistryService.instance();
                try {
                    registry = this.getRegistry(uri);
                    if (registry != null) break block5;
                    return null;
                }
                catch (MalformedURLException me) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)me));
                }
            }
            if (registry.getId() != null) {
                return registry;
            }
            urlString = registry.getLocation();
            if (urlString != null) break block6;
            return null;
        }
        URL url = new URL(urlString);
        return registryService.loadRegistry(url);
    }

    public Registry[] loadRegistries(String[] uris) throws CoreException {
        ArrayList<Registry> list = new ArrayList<Registry>(uris.length);
        int i = 0;
        while (i < uris.length) {
            Registry registry = this.loadRegistry(uris[i]);
            if (registry != null) {
                list.add(registry);
            }
            ++i;
        }
        return list.toArray(new Registry[0]);
    }

    public String[] getRegistryURIs() throws CoreException {
        EList list = this.getIndex().getRegistry();
        ArrayList<String> registryURIs = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Registry registry = (Registry)iterator.next();
            if (registry.getId() != null) {
                registryURIs.add(registry.getId());
                continue;
            }
            if (registry.getRef() == null) continue;
            registryURIs.add(registry.getRef());
        }
        return registryURIs.toArray(new String[0]);
    }

    public void removeRegistry(String uri, boolean deleteDocument) throws CoreException {
        EList list = this.getIndex().getRegistry();
        Registry registry = this.getRegistry(uri);
        if (registry != null) {
            list.remove((Object)registry);
            this.saveIndex();
            if (deleteDocument) {
                registry.getLocation();
            }
        }
    }

    public Taxonomy saveTaxonomy(Taxonomy taxonomy) throws CoreException {
        RegistryService registryService = RegistryService.instance();
        Taxonomy taxonomyRef = null;
        try {
            URL url = this.getURL(String.valueOf(TAXONOMY) + taxonomy.getId());
            registryService.saveTaxonomy(url, taxonomy);
            taxonomyRef = registryService.newTaxonomyReference(taxonomy);
            taxonomyRef.setLocation(url.toString());
            this.addTaxonomyToIndex(taxonomyRef);
            this.saveIndex();
        }
        catch (MalformedURLException me) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)me));
        }
        return registryService.newTaxonomyReference(taxonomyRef);
    }

    public Taxonomy loadTaxonomy(String uri) throws CoreException {
        String urlString;
        RegistryService registryService;
        block6: {
            Taxonomy taxonomy;
            block5: {
                registryService = RegistryService.instance();
                try {
                    taxonomy = this.getTaxonomy(uri);
                    if (taxonomy != null) break block5;
                    return null;
                }
                catch (MalformedURLException me) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)me));
                }
            }
            if (taxonomy.getId() != null) {
                return taxonomy;
            }
            urlString = taxonomy.getLocation();
            if (urlString != null) break block6;
            return null;
        }
        URL url = new URL(urlString);
        return registryService.loadTaxonomy(url);
    }

    public Taxonomy[] loadTaxonomies(String[] uris) throws CoreException {
        ArrayList<Taxonomy> list = new ArrayList<Taxonomy>(uris.length);
        int i = 0;
        while (i < uris.length) {
            Taxonomy taxonomy = this.loadTaxonomy(uris[i]);
            if (taxonomy != null) {
                list.add(taxonomy);
            }
            ++i;
        }
        return list.toArray(new Taxonomy[0]);
    }

    public String[] getTaxonomyURIs() throws CoreException {
        EList list = this.getIndex().getTaxonomy();
        ArrayList<String> taxonomyURIs = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Taxonomy taxonomy = (Taxonomy)iterator.next();
            if (taxonomy.getId() != null) {
                taxonomyURIs.add(taxonomy.getId());
                continue;
            }
            if (taxonomy.getRef() == null) continue;
            taxonomyURIs.add(taxonomy.getRef());
        }
        return taxonomyURIs.toArray(new String[0]);
    }

    public void removeTaxonomy(String uri, boolean deleteDocument) throws CoreException {
        EList list = this.getIndex().getTaxonomy();
        Taxonomy taxonomy = this.getTaxonomy(uri);
        if (taxonomy != null) {
            list.remove((Object)taxonomy);
            this.saveIndex();
            if (deleteDocument) {
                taxonomy.getLocation();
            }
        }
    }

    private Registry getRegistry(String uri) throws CoreException {
        EList list = this.getIndex().getRegistry();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Registry registry = (Registry)it.next();
            if (!uri.equals(registry.getId()) && !uri.equals(registry.getRef())) continue;
            return registry;
        }
        return null;
    }

    private Taxonomy getTaxonomy(String uri) throws CoreException {
        EList list = this.getIndex().getTaxonomy();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Taxonomy taxonomy = (Taxonomy)it.next();
            if (!uri.equals(taxonomy.getId()) && !uri.equals(taxonomy.getRef())) continue;
            return taxonomy;
        }
        return null;
    }
}

