/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.ui.proxy;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jem.internal.ui.proxy.ProxyUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.osgi.framework.Bundle;

public class SelectDefaultConfigurationActionDelegate
extends Action
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private IWorkbenchWindow window;
    protected IJavaProject javaproject;
    private static final Object[] EMPTY = new Object[0];

    protected static IJavaProject getSelectedJavaProject(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object sel = ((IStructuredSelection)selection).getFirstElement();
        if (sel instanceof IProject && ((IProject)sel).isOpen()) {
            return JavaCore.create((IProject)((IProject)sel));
        }
        if (sel instanceof IJavaProject && ((IJavaProject)sel).isOpen()) {
            return (IJavaProject)sel;
        }
        return null;
    }

    public SelectDefaultConfigurationActionDelegate() {
        super(Platform.getResourceString((Bundle)JEMUIPlugin.getPlugin().getBundle(), (String)"%Action.selectDefault"));
        this.setEnabled(false);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run() {
        this.selectDialog();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.javaproject = SelectDefaultConfigurationActionDelegate.getSelectedJavaProject(selection);
        try {
            this.setEnabled(this.javaproject != null && this.javaproject.getProject().getPersistentProperty(ProxyPlugin.PROPERTY_LAUNCH_CONFIGURATION) != null);
        }
        catch (Exception exception) {
            this.setEnabled(false);
        }
        if (action != null) {
            action.setEnabled(this.isEnabled());
        }
        if (this.javaproject != null) {
            this.setToolTipText(MessageFormat.format(Platform.getResourceString((Bundle)JEMUIPlugin.getPlugin().getBundle(), (String)"%Action.selectDefaultTip"), this.javaproject.getElementName()));
        } else {
            this.setToolTipText(this.getText());
        }
    }

    protected void selectDialog() {
        try {
            IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
            CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(this.window.getShell(), (ILabelProvider)labelProvider, new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    return EMPTY;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement != null && inputElement instanceof Object[]) {
                        return (Object[])inputElement;
                    }
                    return null;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            }){

                protected CheckboxTreeViewer createTreeViewer(Composite parent) {
                    CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
                    treeViewer.addCheckStateListener(new ICheckStateListener(this, treeViewer){
                        boolean processingCheck;
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ CheckboxTreeViewer val$treeViewer;
                        {
                            this.this$1 = var1_1;
                            this.val$treeViewer = checkboxTreeViewer;
                            this.processingCheck = false;
                        }

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void checkStateChanged(CheckStateChangedEvent event) {
                            if (this.processingCheck) return;
                            try {
                                this.processingCheck = true;
                                if (event.getChecked()) {
                                    Object[] checked = this.val$treeViewer.getCheckedElements();
                                    int i = 0;
                                    while (i < checked.length) {
                                        if (checked[i] != event.getElement()) {
                                            this.val$treeViewer.setChecked(checked[i], false);
                                        }
                                        ++i;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                this.processingCheck = false;
                                throw throwable;
                            }
                            {
                                Object var4_6 = null;
                                this.processingCheck = false;
                                return;
                            }
                        }
                    });
                    return treeViewer;
                }

                protected Composite createSelectionButtons(Composite composite) {
                    return new Composite(composite, 0);
                }
            };
            dialog.setTitle(ProxyUIMessages.Select_title);
            dialog.setMessage(MessageFormat.format(ProxyUIMessages.Select_message, this.javaproject.getElementName()));
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            ArrayList<ILaunchConfiguration> configsList = new ArrayList<ILaunchConfiguration>(configs.length + 1);
            String jpName = this.javaproject.getElementName();
            int i = 0;
            while (i < configs.length) {
                if ("org.eclipse.jem.proxy".equals(configs[i].getCategory()) && !configs[i].getAttribute(IDebugUIConstants.ATTR_PRIVATE, false) && jpName.equals(configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""))) {
                    configsList.add(configs[i]);
                }
                ++i;
            }
            configs = configsList.toArray(new ILaunchConfiguration[configsList.size()]);
            dialog.setInput((Object)configs);
            String launchName = this.javaproject.getProject().getPersistentProperty(ProxyPlugin.PROPERTY_LAUNCH_CONFIGURATION);
            ILaunchConfiguration config = null;
            if (launchName != null) {
                int i2 = 0;
                while (i2 < configs.length) {
                    if (configs[i2].getName().equals(launchName)) {
                        config = configs[i2];
                        break;
                    }
                    ++i2;
                }
                if (config != null) {
                    dialog.setInitialSelections(new Object[]{config});
                }
            }
            if (dialog.open() == 0) {
                config = (ILaunchConfiguration)dialog.getFirstResult();
                if (config != null) {
                    this.javaproject.getProject().setPersistentProperty(ProxyPlugin.PROPERTY_LAUNCH_CONFIGURATION, config.getName());
                } else {
                    this.javaproject.getProject().setPersistentProperty(ProxyPlugin.PROPERTY_LAUNCH_CONFIGURATION, "...not..set..");
                }
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.window.getShell(), null, null, (IStatus)e.getStatus());
            ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }
}

