/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.layouts;

import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.ColumnData;

public class RowLayout
extends AbstractLayout {
    protected ColumnData columnData;
    protected HashMap figureToContstraintMap = new HashMap();

    private Dimension calculateChildrenSize(IFigure container, List children, int wHint, int hHint, boolean preferred) {
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            String columnIdenifier = (String)this.getConstraint(child);
            Dimension childSize = child.getPreferredSize(wHint, hHint);
            int effectiveWidth = childSize.width;
            if (columnIdenifier != null) {
                this.columnData.stretchColumnWidthIfNeeded(columnIdenifier, childSize.width);
                effectiveWidth = this.columnData.getColumnWidth(columnIdenifier);
            }
            height = Math.max(childSize.height, height);
            width += effectiveWidth;
            ++i;
        }
        return new Dimension(width, height);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        List children = container.getChildren();
        Dimension prefSize = this.calculateChildrenSize(container, children, wHint, hHint, true);
        return prefSize;
    }

    public void layout(IFigure parent) {
        Rectangle clientArea = parent.getClientArea();
        List children = parent.getChildren();
        Rectangle r = new Rectangle();
        r.x = clientArea.x;
        r.y = clientArea.y;
        r.height = clientArea.height;
        int childrenSize = children.size();
        Rectangle[] bounds = new Rectangle[childrenSize];
        int requiredWidth = 0;
        int totalColumnWeight = 0;
        int i = 0;
        while (i < childrenSize) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize(-1, -1);
            int columnWidth = -1;
            String columnIdentifier = (String)this.getConstraint(child);
            if (columnIdentifier != null) {
                columnWidth = this.columnData.getColumnWidth(columnIdentifier);
                totalColumnWeight += this.columnData.getColumnWeight(columnIdentifier);
            }
            r.width = Math.max(childSize.width, columnWidth);
            requiredWidth += r.width;
            bounds[i] = new Rectangle(r);
            r.x += r.width;
            ++i;
        }
        if (totalColumnWeight < 1) {
            totalColumnWeight = 1;
        }
        int extraWidth = Math.max(clientArea.width - requiredWidth, 0);
        int extraWidthAllocated = 0;
        int i2 = 0;
        while (i2 < childrenSize) {
            IFigure child = (IFigure)children.get(i2);
            Rectangle b = bounds[i2];
            if (extraWidth > 0) {
                String columnIdentifier = (String)this.getConstraint(child);
                if (columnIdentifier != null) {
                    int weight = this.columnData.getColumnWeight(columnIdentifier);
                    float fraction = (float)weight / (float)totalColumnWeight;
                    int extraWidthForChild = (int)((float)extraWidth * fraction);
                    b.width += extraWidthForChild;
                    b.x += extraWidthAllocated;
                    extraWidthAllocated += extraWidthForChild;
                } else {
                    b.x += extraWidthAllocated;
                }
            }
            child.setBounds(new Rectangle(b));
            ++i2;
        }
    }

    public ColumnData getColumnData() {
        return this.columnData;
    }

    public void setColumnData(ColumnData columnData) {
        this.columnData = columnData;
    }

    public Object getConstraint(IFigure child) {
        return this.figureToContstraintMap.get(child);
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.figureToContstraintMap.put(child, constraint);
    }

    public void invalidate() {
        super.invalidate();
    }
}

